/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.MailboxesRoutes;
import org.apache.james.webadmin.routes.ReindexingRunningOptionsParser;
import org.apache.james.webadmin.service.UserMailboxesService;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskIdDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.MailboxHaveChildrenException;
import org.apache.james.webadmin.utils.Responses;
import org.apache.james.webadmin.validation.MailboxName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

@Api(tags={"User's Mailbox"})
@Path(value="/users/{username}/mailboxes")
@Produces(value={"application/json"})
public class UserMailboxesRoutes
implements Routes {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMailboxesRoutes.class);
    public static final String USER_MAILBOXES_OPERATIONS_INJECTION_KEY = "userMailboxesOperations";
    public static final String MAILBOX_NAME = ":mailboxName";
    public static final String MAILBOXES = "mailboxes";
    private static final String USER_NAME = ":userName";
    public static final String USERS_BASE = "/users";
    public static final String USER_MAILBOXES_BASE = "/users/:userName/mailboxes";
    public static final String SPECIFIC_MAILBOX = "/users/:userName/mailboxes/:mailboxName";
    private final UserMailboxesService userMailboxesService;
    private final JsonTransformer jsonTransformer;
    private final TaskManager taskManager;
    private final Set<TaskFromRequestRegistry.TaskRegistration> usersMailboxesTaskRegistration;
    private Service service;

    private static Username getUsernameParam(Request request) {
        return Username.of((String)request.params(USER_NAME));
    }

    @Inject
    UserMailboxesRoutes(UserMailboxesService userMailboxesService, JsonTransformer jsonTransformer, TaskManager taskManager, @Named(value="userMailboxesOperations") Set<TaskFromRequestRegistry.TaskRegistration> usersMailboxesTaskRegistration) {
        this.userMailboxesService = userMailboxesService;
        this.jsonTransformer = jsonTransformer;
        this.taskManager = taskManager;
        this.usersMailboxesTaskRegistration = usersMailboxesTaskRegistration;
    }

    public String getBasePath() {
        return USER_MAILBOXES_BASE;
    }

    public void define(Service service) {
        this.service = service;
        this.defineMailboxExists();
        this.defineGetUserMailboxes();
        this.defineCreateUserMailbox();
        this.defineDeleteUserMailbox();
        this.defineDeleteUserMailboxes();
        this.reIndexMailboxesRoute().ifPresent(route -> service.post(USER_MAILBOXES_BASE, route, (ResponseTransformer)this.jsonTransformer));
    }

    @GET
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path")})
    @ApiOperation(value="Listing all mailboxes of user.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of mailboxes", response=String.class), @ApiResponse(code=401, message="Unauthorized. The user is not authenticated on the platform", response=String.class), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetUserMailboxes() {
        this.service.get(USER_MAILBOXES_BASE, (request, response) -> {
            response.status(200);
            try {
                return this.userMailboxesService.listMailboxes(UserMailboxesRoutes.getUsernameParam(request));
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid get on user mailboxes", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid get on user mailboxes").cause((Exception)e).haltError();
            }
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @POST
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path"), @ApiImplicitParam(required=true, name="task", paramType="query parameter", dataType="String", defaultValue="none", example="?task=reIndex", value="Compulsory. Only supported value is `reIndex`")})
    @ApiOperation(value="Perform an action on a user mailbox")
    @ApiResponses(value={@ApiResponse(code=201, message="Task is created", response=TaskIdDto.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side."), @ApiResponse(code=400, message="Bad request - details in the returned error message")})
    public Optional<Route> reIndexMailboxesRoute() {
        return TaskFromRequestRegistry.builder().parameterName("task").registrations(this.usersMailboxesTaskRegistration).buildAsRouteOptional(this.taskManager);
    }

    @DELETE
    @Path(value="/{mailboxName}")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path"), @ApiImplicitParam(required=true, dataType="string", name="mailboxName", paramType="path")})
    @ApiOperation(value="Deleting a mailbox and its children")
    @ApiResponses(value={@ApiResponse(code=204, message="The mailbox now does not exist on the server", response=String.class), @ApiResponse(code=400, message="Invalid mailbox name"), @ApiResponse(code=401, message="Unauthorized. The user is not authenticated on the platform"), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteUserMailbox() {
        this.service.delete(SPECIFIC_MAILBOX, (request, response) -> {
            try {
                this.userMailboxesService.deleteMailbox(UserMailboxesRoutes.getUsernameParam(request), new MailboxName(request.params(MAILBOX_NAME)));
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid delete on user mailbox", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid delete on user mailboxes").cause((Exception)e).haltError();
            }
            catch (MailboxHaveChildrenException e) {
                LOGGER.info("Attempt to delete a mailbox with children");
                throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to delete a mailbox with children").cause((Exception)e).haltError();
            }
            catch (IllegalArgumentException | MailboxNameException e) {
                LOGGER.info("Attempt to delete an invalid mailbox", e);
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to delete an invalid mailbox").cause((Exception)e).haltError();
            }
        });
    }

    @DELETE
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path")})
    @ApiOperation(value="Deleting user mailboxes.")
    @ApiResponses(value={@ApiResponse(code=204, message="The user does not have any mailbox", response=String.class), @ApiResponse(code=401, message="Unauthorized. The user is not authenticated on the platform"), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteUserMailboxes() {
        this.service.delete(USER_MAILBOXES_BASE, (request, response) -> {
            try {
                this.userMailboxesService.deleteMailboxes(UserMailboxesRoutes.getUsernameParam(request));
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid delete on user mailboxes", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid delete on user mailboxes").cause((Exception)e).haltError();
            }
        });
    }

    @GET
    @Path(value="/{mailboxName}")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path"), @ApiImplicitParam(required=true, dataType="string", name="mailboxName", paramType="path")})
    @ApiOperation(value="Testing existence of a mailbox.")
    @ApiResponses(value={@ApiResponse(code=204, message="The mailbox exists", response=String.class), @ApiResponse(code=400, message="Invalid mailbox name"), @ApiResponse(code=401, message="Unauthorized. The user is not authenticated on the platform"), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineMailboxExists() {
        this.service.get(SPECIFIC_MAILBOX, (request, response) -> {
            try {
                if (this.userMailboxesService.testMailboxExists(UserMailboxesRoutes.getUsernameParam(request), new MailboxName(request.params(MAILBOX_NAME)))) {
                    return Responses.returnNoContent((Response)response);
                }
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Mailbox does not exist").haltError();
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid get on user mailbox", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid get on user mailboxes").cause((Exception)e).haltError();
            }
            catch (IllegalArgumentException | MailboxNameException e) {
                LOGGER.info("Attempt to test existence of an invalid mailbox", e);
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to test existence of an invalid mailbox").cause((Exception)e).haltError();
            }
        });
    }

    @PUT
    @Path(value="/{mailboxName}")
    @ApiOperation(value="Create a mailbox of the selected user.", nickname="CreateUserMailbox")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path"), @ApiImplicitParam(required=true, dataType="string", name="mailboxName", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The mailbox now exists on the server.", response=String.class), @ApiResponse(code=400, message="Invalid mailbox name"), @ApiResponse(code=401, message="Unauthorized. The user is not authenticated on the platform"), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineCreateUserMailbox() {
        this.service.put(SPECIFIC_MAILBOX, (request, response) -> {
            try {
                this.userMailboxesService.createMailbox(UserMailboxesRoutes.getUsernameParam(request), new MailboxName(request.params(MAILBOX_NAME)));
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid put on user mailbox", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid get on user mailboxes").cause((Exception)e).haltError();
            }
            catch (IllegalArgumentException | MailboxNameException e) {
                LOGGER.info("Attempt to create an invalid mailbox", e);
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to create an invalid mailbox").cause((Exception)e).haltError();
            }
        });
    }

    public static class UserReIndexingTaskRegistration
    extends TaskFromRequestRegistry.TaskRegistration {
        @Inject
        public UserReIndexingTaskRegistration(ReIndexer reIndexer) {
            super(MailboxesRoutes.RE_INDEX, request -> reIndexer.reIndex(UserMailboxesRoutes.getUsernameParam(request), ReindexingRunningOptionsParser.parse(request)));
        }
    }
}

