/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.QuotaDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;
import org.apache.james.webadmin.jackson.QuotaModule;
import org.apache.james.webadmin.service.GlobalQuotaService;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import org.apache.james.webadmin.validation.QuotaDTOValidator;
import org.apache.james.webadmin.validation.Quotas;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"GlobalQuota"})
@Path(value="/quota")
@Produces(value={"application/json"})
public class GlobalQuotaRoutes
implements Routes {
    public static final String QUOTA_ENDPOINT = "/quota";
    private static final String COUNT_ENDPOINT = "/quota/count";
    private static final String SIZE_ENDPOINT = "/quota/size";
    private final JsonTransformer jsonTransformer;
    private final JsonExtractor<QuotaDTO> jsonExtractor;
    private final QuotaDTOValidator quotaDTOValidator;
    private final GlobalQuotaService globalQuotaService;
    private Service service;

    @Inject
    public GlobalQuotaRoutes(GlobalQuotaService globalQuotaService, JsonTransformer jsonTransformer) {
        this.globalQuotaService = globalQuotaService;
        this.jsonTransformer = jsonTransformer;
        this.jsonExtractor = new JsonExtractor(QuotaDTO.class, new Module[]{new QuotaModule().asJacksonModule()});
        this.quotaDTOValidator = new QuotaDTOValidator();
    }

    public String getBasePath() {
        return QUOTA_ENDPOINT;
    }

    public void define(Service service) {
        this.service = service;
        this.defineGetQuotaCount();
        this.defineDeleteQuotaCount();
        this.defineUpdateQuotaCount();
        this.defineGetQuotaSize();
        this.defineDeleteQuotaSize();
        this.defineUpdateQuotaSize();
        this.defineGetQuota();
        this.defineUpdateQuota();
    }

    @PUT
    @ApiOperation(value="Updating count and size at the same time")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataTypeClass=QuotaDTO.class, paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The value has been updated."), @ApiResponse(code=400, message="The body is not a positive integer or not unlimited value (-1)."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateQuota() {
        this.service.put(QUOTA_ENDPOINT, (request, response) -> {
            try {
                QuotaDTO quotaDTO = (QuotaDTO)this.jsonExtractor.parse(request.body());
                ValidatedQuotaDTO validatedQuotaDTO = this.quotaDTOValidator.validatedQuotaDTO(quotaDTO);
                this.globalQuotaService.defineQuota(validatedQuotaDTO);
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalArgumentException e) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Quota should be positive or unlimited (-1)").cause((Exception)e).haltError();
            }
        });
    }

    @GET
    @ApiOperation(value="Reading count and size at the same time", notes="If there is no limitation for count and/or size, the returned value will be -1")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=QuotaDTO.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetQuota() {
        this.service.get(QUOTA_ENDPOINT, (request, response) -> this.globalQuotaService.getQuota(), (ResponseTransformer)this.jsonTransformer);
    }

    @DELETE
    @Path(value="/size")
    @ApiOperation(value="Removing per quotaroot mail size limitation by updating to unlimited value")
    @ApiResponses(value={@ApiResponse(code=204, message="The value is updated to unlimited value."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteQuotaSize() {
        this.service.delete(SIZE_ENDPOINT, (request, response) -> {
            this.globalQuotaService.deleteMaxSizeQuota();
            return Responses.returnNoContent((Response)response);
        });
    }

    @PUT
    @Path(value="/size")
    @ApiOperation(value="Updating per quotaroot mail size limitation")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="integer", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The value has been updated."), @ApiResponse(code=400, message="The body is not a positive integer."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateQuotaSize() {
        this.service.put(SIZE_ENDPOINT, (request, response) -> {
            QuotaSizeLimit quotaSize = Quotas.quotaSize(request.body());
            this.globalQuotaService.defineMaxSizeQuota(quotaSize);
            return Responses.returnNoContent((Response)response);
        });
    }

    @GET
    @Path(value="/size")
    @ApiOperation(value="Reading per quotaroot mail size limitation")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Long.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetQuotaSize() {
        this.service.get(SIZE_ENDPOINT, this::getQuotaSize, (ResponseTransformer)this.jsonTransformer);
    }

    private QuotaSizeLimit getQuotaSize(Request request, Response response) throws MailboxException {
        Optional<QuotaSizeLimit> maxSizeQuota = this.globalQuotaService.getMaxSizeQuota();
        if (maxSizeQuota.isPresent()) {
            return maxSizeQuota.get();
        }
        response.status(204);
        return null;
    }

    @DELETE
    @Path(value="/count")
    @ApiOperation(value="Removing per quotaroot mail count limitation by updating to unlimited value")
    @ApiResponses(value={@ApiResponse(code=204, message="The value is updated to unlimited value."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteQuotaCount() {
        this.service.delete(COUNT_ENDPOINT, (request, response) -> {
            this.globalQuotaService.deleteMaxCountQuota();
            return Responses.returnNoContent((Response)response);
        });
    }

    @PUT
    @Path(value="/count")
    @ApiOperation(value="Updating per quotaroot mail count limitation")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="integer", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The value has been updated."), @ApiResponse(code=400, message="The body is not a positive integer."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateQuotaCount() {
        this.service.put(COUNT_ENDPOINT, (request, response) -> {
            QuotaCountLimit quotaRequest = Quotas.quotaCount(request.body());
            this.globalQuotaService.defineMaxCountQuota(quotaRequest);
            return Responses.returnNoContent((Response)response);
        });
    }

    @GET
    @Path(value="/count")
    @ApiOperation(value="Reading per quotaroot mail count limitation")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Long.class), @ApiResponse(code=204, message="Quota is not defined"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetQuotaCount() {
        this.service.get(COUNT_ENDPOINT, this::getQuotaCount, (ResponseTransformer)this.jsonTransformer);
    }

    private QuotaCountLimit getQuotaCount(Request request, Response response) throws MailboxException {
        Optional<QuotaCountLimit> maxCountQuota = this.globalQuotaService.getMaxCountQuota();
        if (maxCountQuota.isPresent()) {
            return maxCountQuota.get();
        }
        response.status(204);
        return null;
    }
}

