/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.service.EventDeadLettersService;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskIdDto;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

@Api(tags={"EventDeadLetter"})
@Path(value="/events/deadLetter")
@Produces(value={"application/json"})
public class EventDeadLettersRoutes
implements Routes {
    public static final String BASE_PATH = "/events/deadLetter";
    private static final String GROUP_PARAM = ":group";
    private static final String INSERTION_ID_PARAMETER = ":insertionId";
    private static final String INTERNAL_SERVER_ERROR = "Internal server error - Something went bad on the server side.";
    private static final TaskRegistrationKey RE_DELIVER = TaskRegistrationKey.of((String)"reDeliver");
    private final EventDeadLettersService eventDeadLettersService;
    private final EventSerializer eventSerializer;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;

    @Inject
    EventDeadLettersRoutes(EventDeadLettersService eventDeadLettersService, EventSerializer eventSerializer, TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.eventDeadLettersService = eventDeadLettersService;
        this.eventSerializer = eventSerializer;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        service.post(BASE_PATH, this.performActionOnAllEvents(), (ResponseTransformer)this.jsonTransformer);
        service.get("/events/deadLetter/groups", this::listGroups, (ResponseTransformer)this.jsonTransformer);
        service.get("/events/deadLetter/groups/:group", this::listFailedEvents, (ResponseTransformer)this.jsonTransformer);
        service.post("/events/deadLetter/groups/:group", this.performActionOnGroupEvents(), (ResponseTransformer)this.jsonTransformer);
        service.get("/events/deadLetter/groups/:group/:insertionId", this::getEventDetails);
        service.delete("/events/deadLetter/groups/:group/:insertionId", this::deleteEvent);
        service.post("/events/deadLetter/groups/:group/:insertionId", this.performActionOnSingleEvent(), (ResponseTransformer)this.jsonTransformer);
    }

    @POST
    @Path(value="")
    @ApiOperation(value="Performing action on all events")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="String", name="action", paramType="query", example="?action=reDeliver", value="Specify the action to perform on all events. 'reDeliver' is supported as an action, and its purpose is to attempt a redelivery of all events present in dead letter.")})
    @ApiResponses(value={@ApiResponse(code=201, message="The taskId of the given scheduled task", response=TaskIdDto.class, responseHeaders={@ResponseHeader(name="Location", description="URL of the resource associated with the scheduled task")}), @ApiResponse(code=400, message="Invalid action argument"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public Route performActionOnAllEvents() {
        return TaskFromRequestRegistry.of((TaskRegistrationKey)RE_DELIVER, request -> this.eventDeadLettersService.redeliverAllEvents()).asRoute(this.taskManager);
    }

    @GET
    @Path(value="/groups")
    @ApiOperation(value="List groups")
    @ApiResponses(value={@ApiResponse(code=200, message="OK - list group names", response=List.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    private Iterable<String> listGroups(Request request, Response response) {
        return this.eventDeadLettersService.listGroupsAsStrings();
    }

    @GET
    @Path(value="/groups/:group")
    @ApiOperation(value="List failed events for a given group")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="group", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory. Needs to be a valid group name")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK - list of insertionIds of failed event for a given group", response=List.class), @ApiResponse(code=400, message="Invalid group name"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    private Iterable<String> listFailedEvents(Request request, Response response) {
        Group group = this.parseGroup(request);
        return this.eventDeadLettersService.listGroupsInsertionIdsAsStrings(group);
    }

    @POST
    @Path(value="/groups/:group")
    @ApiOperation(value="Performing action on events of a particular group")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="group", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory. Needs to be a valid group name"), @ApiImplicitParam(required=true, dataType="String", name="action", paramType="query", example="?action=reDeliver", value="Specify the action to perform on all events of a particular group. 'reDeliver' is supported as an action, and its purpose is to attempt a redelivery of all events present in dead letter for the specified group.")})
    @ApiResponses(value={@ApiResponse(code=201, message="The taskId of the given scheduled task", response=TaskIdDto.class, responseHeaders={@ResponseHeader(name="Location", description="URL of the resource associated with the scheduled task")}), @ApiResponse(code=400, message="Invalid group name or action argument"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public Route performActionOnGroupEvents() {
        return TaskFromRequestRegistry.of((TaskRegistrationKey)RE_DELIVER, request -> this.eventDeadLettersService.redeliverGroupEvents(this.parseGroup(request))).asRoute(this.taskManager);
    }

    @GET
    @Path(value="/groups/:group/:insertionId")
    @ApiOperation(value="Returns an event detail")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="group", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory. Needs to be a valid group name"), @ApiImplicitParam(required=true, name="insertionId", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory. Needs to be a valid insertionId")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK - returns an event detail", response=Event.class), @ApiResponse(code=400, message="Invalid group name or insertion id"), @ApiResponse(code=404, message="No event with this insertionId"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    private String getEventDetails(Request request, Response response) {
        Group group = this.parseGroup(request);
        EventDeadLetters.InsertionId insertionId = this.parseInsertionId(request);
        return (String)this.eventDeadLettersService.getEvent(group, insertionId).map(arg_0 -> ((EventSerializer)this.eventSerializer).toJson(arg_0)).block();
    }

    @DELETE
    @Path(value="/groups/:group/:insertionId")
    @ApiOperation(value="Deletes an event")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="group", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory. Needs to be a valid group name"), @ApiImplicitParam(required=true, name="insertionId", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory. Needs to be a valid insertionId")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK - Event deleted"), @ApiResponse(code=400, message="Invalid group name or insertion id"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    private String deleteEvent(Request request, Response response) {
        Group group = this.parseGroup(request);
        EventDeadLetters.InsertionId insertionId = this.parseInsertionId(request);
        this.eventDeadLettersService.deleteEvent(group, insertionId);
        return Responses.returnNoContent((Response)response);
    }

    @POST
    @Path(value="/groups/:group/:insertionId")
    @ApiOperation(value="Performing action on an event")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="group", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory. Needs to be a valid group name"), @ApiImplicitParam(required=true, name="insertionId", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory. Needs to be a valid insertionId"), @ApiImplicitParam(required=true, dataType="String", name="action", paramType="query", example="?action=reDeliver", value="Specify the action to perform on an unique event. 'reDeliver' is supported as an action, and its purpose is to attempt a redelivery of the specified event.")})
    @ApiResponses(value={@ApiResponse(code=201, message="The taskId of the given scheduled task", response=TaskIdDto.class, responseHeaders={@ResponseHeader(name="Location", description="URL of the resource associated with the scheduled task")}), @ApiResponse(code=400, message="Invalid group name, insertion id or action argument"), @ApiResponse(code=404, message="No event with this insertionId"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public Route performActionOnSingleEvent() {
        return TaskFromRequestRegistry.of((TaskRegistrationKey)RE_DELIVER, request -> this.eventDeadLettersService.redeliverSingleEvent(this.parseGroup(request), this.parseInsertionId(request))).asRoute(this.taskManager);
    }

    private Group parseGroup(Request request) {
        String groupAsString = request.params(GROUP_PARAM);
        try {
            return Group.deserialize((String)groupAsString);
        }
        catch (Group.GroupDeserializationException e) {
            throw ErrorResponder.builder().statusCode(400).message("Can not deserialize the supplied group: %s", new Object[]{groupAsString}).cause((Exception)((Object)e)).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).haltError();
        }
    }

    private EventDeadLetters.InsertionId parseInsertionId(Request request) {
        String insertionIdAsString = request.params(INSERTION_ID_PARAMETER);
        try {
            return EventDeadLetters.InsertionId.of((String)insertionIdAsString);
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).message("Can not deserialize the supplied insertionId: %s", new Object[]{insertionIdAsString}).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).haltError();
        }
    }
}

