/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraMailRepositoryModule {
    public static final CassandraModule MODULE = CassandraModule.builder().type("header").statement(statement -> (CreateType)((CreateType)statement.addColumn("headerName", DataType.text())).addColumn("headerValue", DataType.text())).table("mailRepositoryCount").comment("Projection maintaining per mail repository mail counter").statement(statement -> (Create)statement.addPartitionKey("name", DataType.text()).addColumn("count", DataType.counter())).table("mailRepositoryKeys").comment("Per-mailRepository mail key list").statement(statement -> statement.addPartitionKey("name", DataType.text()).addClusteringColumn("mailKey", DataType.text())).table("mailRepositoryContent").comment("Stores the mails for a given repository. Content is stored with other blobs").statement(statement -> (Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)statement.addPartitionKey("name", DataType.text()).addPartitionKey("mailKey", DataType.text()).addColumn("messageSize", DataType.bigint())).addColumn("state", DataType.text())).addColumn("headerBlobId", DataType.text())).addColumn("bodyBlobId", DataType.text())).addColumn("attributes", (DataType)DataType.map((DataType)DataType.text(), (DataType)DataType.blob()))).addColumn("errorMessage", DataType.text())).addColumn("sender", DataType.text())).addColumn("recipients", (DataType)DataType.list((DataType)DataType.text()))).addColumn("remoteHost", DataType.text())).addColumn("remoteAddr", DataType.text())).addColumn("lastUpdated", DataType.timestamp())).addUDTMapColumn("perRecipientSpecificHeaders", DataType.text(), SchemaBuilder.frozen((String)"header"))).table("mailRepositoryContentV2").comment("Stores the mails for a given repository. Content is stored with other blobs. This v2 version was introduced to support multiple headers for each user. The attributes are store as Json introduced in Mailet API v3.2.").statement(statement -> (Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)statement.addPartitionKey("name", DataType.text()).addPartitionKey("mailKey", DataType.text()).addColumn("messageSize", DataType.bigint())).addColumn("state", DataType.text())).addColumn("headerBlobId", DataType.text())).addColumn("bodyBlobId", DataType.text())).addColumn("attributes", (DataType)DataType.map((DataType)DataType.text(), (DataType)DataType.text()))).addColumn("errorMessage", DataType.text())).addColumn("sender", DataType.text())).addColumn("recipients", (DataType)DataType.list((DataType)DataType.text()))).addColumn("remoteHost", DataType.text())).addColumn("remoteAddr", DataType.text())).addColumn("lastUpdated", DataType.timestamp())).addColumn("perRecipientSpecificHeaders", (DataType)DataType.list((DataType)TupleType.of((ProtocolVersion)ProtocolVersion.NEWEST_SUPPORTED, (CodecRegistry)CodecRegistry.DEFAULT_INSTANCE, (DataType[])new DataType[]{DataType.text(), DataType.text(), DataType.text()})))).build();
}

