/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.NamespaceRequest;
import org.apache.james.imap.message.response.NamespaceResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class NamespaceProcessor
extends AbstractMailboxProcessor<NamespaceRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_NAMESPACES);

    public NamespaceProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(NamespaceRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(NamespaceRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        List<NamespaceResponse.Namespace> personalNamespaces = this.buildPersonalNamespaces(mailboxSession, session);
        List<NamespaceResponse.Namespace> otherUsersNamespaces = this.buildOtherUsersSpaces(mailboxSession, session);
        List<NamespaceResponse.Namespace> sharedNamespaces = this.buildSharedNamespaces(mailboxSession, session);
        NamespaceResponse response = new NamespaceResponse(personalNamespaces, otherUsersNamespaces, sharedNamespaces);
        responder.respond(response);
        this.unsolicitedResponses(session, responder, false);
        this.okComplete(request, responder);
    }

    private List<NamespaceResponse.Namespace> buildPersonalNamespaces(MailboxSession mailboxSession, ImapSession session) {
        ArrayList<NamespaceResponse.Namespace> personalSpaces = new ArrayList<NamespaceResponse.Namespace>();
        String personal = "";
        if (session.supportMultipleNamespaces()) {
            personal = mailboxSession.getPersonalSpace();
        }
        personalSpaces.add(new NamespaceResponse.Namespace(personal, mailboxSession.getPathDelimiter()));
        return personalSpaces;
    }

    private List<NamespaceResponse.Namespace> buildOtherUsersSpaces(MailboxSession mailboxSession, ImapSession session) {
        ArrayList<NamespaceResponse.Namespace> otherUsersSpaces;
        String otherUsersSpace = mailboxSession.getOtherUsersSpace();
        if (!session.supportMultipleNamespaces() || otherUsersSpace == null) {
            otherUsersSpaces = null;
        } else {
            otherUsersSpaces = new ArrayList<NamespaceResponse.Namespace>(1);
            otherUsersSpaces.add(new NamespaceResponse.Namespace(otherUsersSpace, mailboxSession.getPathDelimiter()));
        }
        return otherUsersSpaces;
    }

    private List<NamespaceResponse.Namespace> buildSharedNamespaces(MailboxSession mailboxSession, ImapSession session) {
        ArrayList<NamespaceResponse.Namespace> sharedNamespaces = null;
        Collection sharedSpaces = mailboxSession.getSharedSpaces();
        if (session.supportMultipleNamespaces() && !sharedSpaces.isEmpty()) {
            sharedNamespaces = new ArrayList<NamespaceResponse.Namespace>(sharedSpaces.size());
            for (String space : sharedSpaces) {
                sharedNamespaces.add(new NamespaceResponse.Namespace(space, mailboxSession.getPathDelimiter()));
            }
        }
        return sharedNamespaces;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected Closeable addContextToMDC(NamespaceRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"NAMESPACE").build();
    }
}

