/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.mailbox.cassandra.mail.task.MessageInconsistenciesEntry;
import org.apache.james.mailbox.cassandra.mail.task.SolveMessageInconsistenciesService;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class SolveMessageInconsistenciesTask
implements Task {
    static final TaskType SOLVE_MESSAGE_INCONSISTENCIES = TaskType.of((String)"solve-message-inconsistencies");
    private final SolveMessageInconsistenciesService service;
    private SolveMessageInconsistenciesService.Context context;
    private SolveMessageInconsistenciesService.RunningOptions runningOptions;

    public SolveMessageInconsistenciesTask(SolveMessageInconsistenciesService service, SolveMessageInconsistenciesService.RunningOptions runningOptions) {
        this.service = service;
        this.runningOptions = runningOptions;
        this.context = new SolveMessageInconsistenciesService.Context();
    }

    public Task.Result run() {
        return (Task.Result)this.service.fixMessageInconsistencies(this.context, this.runningOptions).block();
    }

    public TaskType type() {
        return SOLVE_MESSAGE_INCONSISTENCIES;
    }

    public SolveMessageInconsistenciesService.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        SolveMessageInconsistenciesService.Context.Snapshot snapshot = this.context.snapshot();
        return Optional.of(new Details(Clock.systemUTC().instant(), snapshot.getProcessedImapUidEntries(), snapshot.getProcessedMessageIdEntries(), snapshot.getAddedMessageIdEntries(), snapshot.getUpdatedMessageIdEntries(), snapshot.getRemovedMessageIdEntries(), this.runningOptions, (ImmutableList<MessageInconsistenciesEntry>)((ImmutableList)snapshot.getFixedInconsistencies().stream().map(this::toMessageInconsistenciesEntry).collect(Guavate.toImmutableList())), (ImmutableList<MessageInconsistenciesEntry>)((ImmutableList)snapshot.getErrors().stream().map(this::toMessageInconsistenciesEntry).collect(Guavate.toImmutableList()))));
    }

    private MessageInconsistenciesEntry toMessageInconsistenciesEntry(ComposedMessageId composedMessageId) {
        return MessageInconsistenciesEntry.builder().mailboxId(composedMessageId.getMailboxId().serialize()).messageId(composedMessageId.getMessageId().serialize()).messageUid(composedMessageId.getUid().asLong());
    }

    public static class Details
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant instant;
        private final long processedImapUidEntries;
        private final long processedMessageIdEntries;
        private final long addedMessageIdEntries;
        private final long updatedMessageIdEntries;
        private final long removedMessageIdEntries;
        private final SolveMessageInconsistenciesService.RunningOptions runningOptions;
        private final ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies;
        private final ImmutableList<MessageInconsistenciesEntry> errors;

        public Details(Instant instant, long processedImapUidEntries, long processedMessageIdEntries, long addedMessageIdEntries, long updatedMessageIdEntries, long removedMessageIdEntries, SolveMessageInconsistenciesService.RunningOptions runningOptions, ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies, ImmutableList<MessageInconsistenciesEntry> errors) {
            this.instant = instant;
            this.processedImapUidEntries = processedImapUidEntries;
            this.processedMessageIdEntries = processedMessageIdEntries;
            this.addedMessageIdEntries = addedMessageIdEntries;
            this.updatedMessageIdEntries = updatedMessageIdEntries;
            this.removedMessageIdEntries = removedMessageIdEntries;
            this.runningOptions = runningOptions;
            this.fixedInconsistencies = fixedInconsistencies;
            this.errors = errors;
        }

        public Instant timestamp() {
            return this.instant;
        }

        public long getProcessedImapUidEntries() {
            return this.processedImapUidEntries;
        }

        public long getProcessedMessageIdEntries() {
            return this.processedMessageIdEntries;
        }

        public long getAddedMessageIdEntries() {
            return this.addedMessageIdEntries;
        }

        public long getUpdatedMessageIdEntries() {
            return this.updatedMessageIdEntries;
        }

        public long getRemovedMessageIdEntries() {
            return this.removedMessageIdEntries;
        }

        public SolveMessageInconsistenciesService.RunningOptions getRunningOptions() {
            return this.runningOptions;
        }

        public ImmutableList<MessageInconsistenciesEntry> getFixedInconsistencies() {
            return this.fixedInconsistencies;
        }

        public ImmutableList<MessageInconsistenciesEntry> getErrors() {
            return this.errors;
        }
    }
}

