/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.eventsourcing.acl;

import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.mailbox.cassandra.mail.CassandraUserMailboxRightsDAO;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.ACLUpdated;

public class UserRightsDAOSubscriber
implements Subscriber {
    private final CassandraUserMailboxRightsDAO userRightsDAO;

    public UserRightsDAOSubscriber(CassandraUserMailboxRightsDAO userRightsDAO) {
        this.userRightsDAO = userRightsDAO;
    }

    public void handle(Event event) {
        if (event instanceof ACLUpdated) {
            ACLUpdated aclUpdated = (ACLUpdated)event;
            this.userRightsDAO.update(aclUpdated.mailboxId(), aclUpdated.getAclDiff()).block();
        }
    }
}

