/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.MessageAttachmentRepresentation;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class CassandraMessageDAO {
    public static final long DEFAULT_LONG_VALUE = 0L;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final CassandraTypesProvider typesProvider;
    private final BlobStore blobStore;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement insert;
    private final PreparedStatement delete;
    private final PreparedStatement select;
    private final PreparedStatement selectAll;
    private final Cid.CidParser cidParser;
    private final CassandraMessageId.Factory messageIdFactory;
    private final ConsistencyLevel consistencyLevel;

    @Inject
    public CassandraMessageDAO(Session session, CassandraTypesProvider typesProvider, BlobStore blobStore, BlobId.Factory blobIdFactory, CassandraMessageId.Factory messageIdFactory, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.messageIdFactory = messageIdFactory;
        this.consistencyLevel = consistenciesConfiguration.getRegular();
        this.typesProvider = typesProvider;
        this.blobStore = blobStore;
        this.blobIdFactory = blobIdFactory;
        this.insert = this.prepareInsert(session);
        this.delete = this.prepareDelete(session);
        this.select = this.prepareSelect(session);
        this.selectAll = this.prepareSelectAll(session);
        this.cidParser = Cid.parser().relaxed();
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageV2").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    private PreparedStatement prepareSelectAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageV2"));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"messageV2").value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("internalDate", (Object)QueryBuilder.bindMarker((String)"internalDate")).value("bodyStartOctet", (Object)QueryBuilder.bindMarker((String)"bodyStartOctet")).value("fullContentOctets", (Object)QueryBuilder.bindMarker((String)"fullContentOctets")).value("bodyOctets", (Object)QueryBuilder.bindMarker((String)"bodyOctets")).value("bodyContent", (Object)QueryBuilder.bindMarker((String)"bodyContent")).value("headerContent", (Object)QueryBuilder.bindMarker((String)"headerContent")).value("properties", (Object)QueryBuilder.bindMarker((String)"properties")).value("textualLineCount", (Object)QueryBuilder.bindMarker((String)"textualLineCount")).value("attachments", (Object)QueryBuilder.bindMarker((String)"attachments")));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("messageV2").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    public Flux<MessageRepresentation> list() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAll.bind()).map(this::message);
    }

    public Mono<Void> save(MailboxMessage message) throws MailboxException {
        return this.saveContent(message).flatMap(pair -> this.cassandraAsyncExecutor.executeVoid((Statement)this.boundWriteStatement(message, (Tuple2<BlobId, BlobId>)pair)));
    }

    private Mono<Tuple2<BlobId, BlobId>> saveContent(final MailboxMessage message) throws MailboxException {
        try {
            byte[] headerContent = IOUtils.toByteArray((InputStream)message.getHeaderContent());
            ByteSource bodyByteSource = new ByteSource(){

                public InputStream openStream() {
                    try {
                        return message.getBodyContent();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public long size() {
                    return message.getBodyOctets();
                }
            };
            Mono headerFuture = Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), headerContent, BlobStore.StoragePolicy.SIZE_BASED));
            Mono bodyFuture = Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), bodyByteSource, BlobStore.StoragePolicy.LOW_COST));
            return headerFuture.zipWith(bodyFuture);
        }
        catch (IOException e) {
            throw new MailboxException("Error saving mail content", (Throwable)e);
        }
    }

    private BoundStatement boundWriteStatement(MailboxMessage message, Tuple2<BlobId, BlobId> pair) {
        CassandraMessageId messageId = (CassandraMessageId)message.getMessageId();
        return this.insert.bind().setUUID("messageId", messageId.get()).setTimestamp("internalDate", message.getInternalDate()).setInt("bodyStartOctet", (int)message.getHeaderOctets()).setLong("fullContentOctets", message.getFullContentOctets()).setLong("bodyOctets", message.getBodyOctets()).setString("bodyContent", ((BlobId)pair.getT2()).asString()).setString("headerContent", ((BlobId)pair.getT1()).asString()).setLong("textualLineCount", Optional.ofNullable(message.getTextualLineCount()).orElse(0L).longValue()).setList("properties", this.buildPropertiesUdt(message)).setList("attachments", this.buildAttachmentUdt(message));
    }

    private ImmutableList<UDTValue> buildAttachmentUdt(MailboxMessage message) {
        return (ImmutableList)message.getAttachments().stream().map(this::toUDT).collect(Guavate.toImmutableList());
    }

    private UDTValue toUDT(MessageAttachmentMetadata messageAttachment) {
        UDTValue result = (UDTValue)((UDTValue)this.typesProvider.getDefinedUserType("attachments").newValue().setString("id", messageAttachment.getAttachmentId().getId())).setBool("isInline", messageAttachment.isInline());
        messageAttachment.getName().ifPresent(name -> result.setString("name", name));
        messageAttachment.getCid().ifPresent(cid -> result.setString("cid", cid.getValue()));
        return result;
    }

    private List<UDTValue> buildPropertiesUdt(MailboxMessage message) {
        return (List)message.getProperties().toProperties().stream().map(property -> (UDTValue)((UDTValue)((UDTValue)this.typesProvider.getDefinedUserType("properties").newValue().setString("namespace", property.getNamespace())).setString("name", property.getLocalName())).setString("value", property.getValue())).collect(Guavate.toImmutableList());
    }

    public Mono<MessageRepresentation> retrieveMessage(ComposedMessageIdWithMetaData id, MessageMapper.FetchType fetchType) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)id.getComposedMessageId().getMessageId();
        return this.retrieveMessage(cassandraMessageId, fetchType);
    }

    public Mono<MessageRepresentation> retrieveMessage(CassandraMessageId cassandraMessageId, MessageMapper.FetchType fetchType) {
        return this.retrieveRow(cassandraMessageId).flatMap(resultSet -> this.message((ResultSet)resultSet, cassandraMessageId, fetchType));
    }

    private Mono<ResultSet> retrieveRow(CassandraMessageId messageId) {
        return this.cassandraAsyncExecutor.execute(this.select.bind().setUUID("messageId", messageId.get()).setConsistencyLevel(this.consistencyLevel));
    }

    private Mono<MessageRepresentation> message(ResultSet rows, CassandraMessageId cassandraMessageId, MessageMapper.FetchType fetchType) {
        if (rows.isExhausted()) {
            return Mono.empty();
        }
        Row row = rows.one();
        BlobId headerId = this.retrieveBlobId("headerContent", row);
        BlobId bodyId = this.retrieveBlobId("bodyContent", row);
        int bodyStartOctet = row.getInt("bodyStartOctet");
        return this.buildContentRetriever(fetchType, headerId, bodyId, bodyStartOctet).map(content -> new MessageRepresentation(cassandraMessageId, row.getTimestamp("internalDate"), row.getLong("fullContentOctets"), row.getInt("bodyStartOctet"), (Content)new ByteContent(content), this.getProperties(row), (List)this.getAttachments(row).collect(Guavate.toImmutableList()), headerId, bodyId));
    }

    private MessageRepresentation message(Row row) {
        BlobId headerId = this.retrieveBlobId("headerContent", row);
        BlobId bodyId = this.retrieveBlobId("bodyContent", row);
        CassandraMessageId messageId = CassandraMessageId.Factory.of(row.getUUID("messageId"));
        return new MessageRepresentation(messageId, row.getTimestamp("internalDate"), row.getLong("fullContentOctets"), row.getInt("bodyStartOctet"), (Content)new ByteContent(EMPTY_BYTE_ARRAY), this.getProperties(row), (List)this.getAttachments(row).collect(Guavate.toImmutableList()), headerId, bodyId);
    }

    private Properties getProperties(Row row) {
        PropertyBuilder property = new PropertyBuilder(row.getList("properties", UDTValue.class).stream().map(this::toProperty).collect(Collectors.toList()));
        property.setTextualLineCount(Long.valueOf(row.getLong("textualLineCount")));
        return property.build();
    }

    private Property toProperty(UDTValue udtValue) {
        return new Property(udtValue.getString("namespace"), udtValue.getString("name"), udtValue.getString("value"));
    }

    private Stream<MessageAttachmentRepresentation> getAttachments(Row row) {
        List udtValues = row.getList("attachments", UDTValue.class);
        return this.attachmentByIds(udtValues);
    }

    private Stream<MessageAttachmentRepresentation> attachmentByIds(List<UDTValue> udtValues) {
        return udtValues.stream().map(this::messageAttachmentByIdFrom);
    }

    private MessageAttachmentRepresentation messageAttachmentByIdFrom(UDTValue udtValue) {
        return MessageAttachmentRepresentation.builder().attachmentId(AttachmentId.from((String)udtValue.getString("id"))).name(udtValue.getString("name")).cid(this.cidParser.parse(udtValue.getString("cid"))).isInline(udtValue.getBool("isInline")).build();
    }

    public Mono<Void> delete(CassandraMessageId messageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setUUID("messageId", messageId.get()));
    }

    private Mono<byte[]> buildContentRetriever(MessageMapper.FetchType fetchType, BlobId headerId, BlobId bodyId, int bodyStartOctet) {
        switch (fetchType) {
            case Full: {
                return this.getFullContent(headerId, bodyId);
            }
            case Headers: {
                return this.getContent(headerId, BlobStore.StoragePolicy.SIZE_BASED);
            }
            case Body: {
                return this.getContent(bodyId, BlobStore.StoragePolicy.LOW_COST).map(data -> Bytes.concat((byte[][])new byte[][]{new byte[bodyStartOctet], data}));
            }
            case Metadata: {
                return Mono.just((Object)EMPTY_BYTE_ARRAY);
            }
        }
        throw new RuntimeException("Unknown FetchType " + fetchType);
    }

    private Mono<byte[]> getFullContent(BlobId headerId, BlobId bodyId) {
        return this.getContent(headerId, BlobStore.StoragePolicy.SIZE_BASED).zipWith(this.getContent(bodyId, BlobStore.StoragePolicy.LOW_COST), (xva$0, xva$1) -> Bytes.concat((byte[][])new byte[][]{xva$0, xva$1}));
    }

    private Mono<byte[]> getContent(BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return Mono.from((Publisher)this.blobStore.readBytes(this.blobStore.getDefaultBucketName(), blobId, storagePolicy));
    }

    private BlobId retrieveBlobId(String field, Row row) {
        return this.blobIdFactory.from(row.getString(field));
    }
}

