/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.table.CassandraAttachmentMessageIdTable;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.MessageId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAttachmentMessageIdDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement deleteStatement;
    private final MessageId.Factory messageIdFactory;

    @Inject
    public CassandraAttachmentMessageIdDAO(Session session, MessageId.Factory messageIdFactory) {
        this.messageIdFactory = messageIdFactory;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.selectStatement = this.prepareSelect(session);
        this.insertStatement = this.prepareInsert(session);
        this.deleteStatement = this.prepareDelete(session);
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"attachmentMessageId").value("attachmentIdAsUUID", (Object)QueryBuilder.bindMarker((String)"attachmentIdAsUUID")).value("attachmentId", (Object)QueryBuilder.bindMarker((String)"attachmentId")).value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("attachmentMessageId").where(QueryBuilder.eq((String)"attachmentIdAsUUID", (Object)QueryBuilder.bindMarker((String)"attachmentIdAsUUID"))).and(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraAttachmentMessageIdTable.FIELDS).from("attachmentMessageId").where(QueryBuilder.eq((String)"attachmentIdAsUUID", (Object)QueryBuilder.bindMarker((String)"attachmentIdAsUUID"))));
    }

    public Flux<MessageId> getOwnerMessageIds(AttachmentId attachmentId) {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectStatement.bind().setUUID("attachmentIdAsUUID", attachmentId.asUUID())).map(this::rowToMessageId);
    }

    private MessageId rowToMessageId(Row row) {
        return this.messageIdFactory.fromString(row.getString("messageId"));
    }

    public Mono<Void> storeAttachmentForMessageId(AttachmentId attachmentId, MessageId ownerMessageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertStatement.bind().setUUID("attachmentIdAsUUID", attachmentId.asUUID()).setString("attachmentId", attachmentId.getId()).setString("messageId", ownerMessageId.serialize()));
    }

    public Mono<Void> delete(AttachmentId attachmentId, MessageId ownerMessageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteStatement.bind().setUUID("attachmentIdAsUUID", attachmentId.asUUID()).setString("messageId", ownerMessageId.serialize()));
    }
}

