/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init.configuration;

import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.cassandra.init.configuration.QueryLoggerConfiguration;
import org.apache.james.util.Host;

public class ClusterConfiguration {
    private static final String CASSANDRA_NODES = "cassandra.nodes";
    public static final String CASSANDRA_CREATE_KEYSPACE = "cassandra.keyspace.create";
    public static final String CASSANDRA_USER = "cassandra.user";
    public static final String CASSANDRA_PASSWORD = "cassandra.password";
    public static final String CASSANDRA_SSL = "cassandra.ssl";
    public static final String READ_TIMEOUT_MILLIS = "cassandra.readTimeoutMillis";
    public static final String CONNECT_TIMEOUT_MILLIS = "cassandra.connectTimeoutMillis";
    public static final String CONNECTION_MAX_RETRY = "cassandra.retryConnection.maxRetries";
    public static final String CONNECTION_RETRY_MIN_DELAY = "cassandra.retryConnection.minDelay";
    private static final int DEFAULT_CONNECTION_MAX_RETRIES = 10;
    private static final int DEFAULT_CONNECTION_MIN_DELAY = 5000;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 5000;
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 5000;
    public static final int DEFAULT_CASSANDRA_PORT = 9042;
    private static final boolean DEFAULT_SSL = false;
    private final List<Host> hosts;
    private final boolean createKeyspace;
    private final int minDelay;
    private final int maxRetry;
    private final Optional<QueryLoggerConfiguration> queryLoggerConfiguration;
    private final Optional<PoolingOptions> poolingOptions;
    private final int readTimeoutMillis;
    private final int connectTimeoutMillis;
    private final boolean useSsl;
    private final Optional<String> username;
    private final Optional<String> password;

    public static Builder builder() {
        return new Builder();
    }

    public static ClusterConfiguration from(Configuration configuration) {
        boolean createKeySpace = Optional.ofNullable(configuration.getBoolean(CASSANDRA_CREATE_KEYSPACE, null)).filter(Boolean::booleanValue).isPresent();
        Builder builder = ClusterConfiguration.builder().hosts(ClusterConfiguration.listCassandraServers(configuration)).minDelay(Optional.ofNullable(configuration.getInteger(CONNECTION_RETRY_MIN_DELAY, null))).maxRetry(Optional.ofNullable(configuration.getInteger(CONNECTION_MAX_RETRY, null))).queryLoggerConfiguration(QueryLoggerConfiguration.from(configuration)).poolingOptions(ClusterConfiguration.readPoolingOptions(configuration)).readTimeoutMillis(Optional.ofNullable(configuration.getInteger(READ_TIMEOUT_MILLIS, null))).connectTimeoutMillis(Optional.ofNullable(configuration.getInteger(CONNECT_TIMEOUT_MILLIS, null))).useSsl(Optional.ofNullable(configuration.getBoolean(CASSANDRA_SSL, null))).username(Optional.ofNullable(configuration.getString(CASSANDRA_USER, null))).password(Optional.ofNullable(configuration.getString(CASSANDRA_PASSWORD, null)));
        if (createKeySpace) {
            builder = builder.createKeyspace();
        }
        return builder.build();
    }

    private static List<Host> listCassandraServers(Configuration configuration) {
        String[] ipAndPorts = configuration.getStringArray(CASSANDRA_NODES);
        return (List)Arrays.stream(ipAndPorts).map(string -> Host.parseConfString((String)string, (int)9042)).collect(Guavate.toImmutableList());
    }

    private static Optional<PoolingOptions> readPoolingOptions(Configuration configuration) {
        Optional<Integer> maxConnections = Optional.ofNullable(configuration.getInteger("cassandra.pooling.local.max.connections", null));
        Optional<Integer> maxRequests = Optional.ofNullable(configuration.getInteger("cassandra.pooling.local.max.requests", null));
        Optional<Integer> poolingTimeout = Optional.ofNullable(configuration.getInteger("cassandra.pooling.timeout", null));
        Optional<Integer> heartbeatTimeout = Optional.ofNullable(configuration.getInteger("cassandra.pooling.heartbeat.timeout", null));
        Optional<Integer> maxQueueSize = Optional.ofNullable(configuration.getInteger("cassandra.pooling.max.queue.size", null));
        if (!(maxConnections.isPresent() || maxRequests.isPresent() || poolingTimeout.isPresent() || heartbeatTimeout.isPresent() || maxQueueSize.isPresent())) {
            return Optional.empty();
        }
        PoolingOptions result = new PoolingOptions();
        maxConnections.ifPresent(value -> {
            result.setMaxConnectionsPerHost(HostDistance.LOCAL, value.intValue());
            result.setMaxConnectionsPerHost(HostDistance.REMOTE, value.intValue());
        });
        maxRequests.ifPresent(value -> {
            result.setMaxRequestsPerConnection(HostDistance.LOCAL, value.intValue());
            result.setMaxRequestsPerConnection(HostDistance.REMOTE, value.intValue());
        });
        poolingTimeout.ifPresent(arg_0 -> ((PoolingOptions)result).setPoolTimeoutMillis(arg_0));
        heartbeatTimeout.ifPresent(arg_0 -> ((PoolingOptions)result).setHeartbeatIntervalSeconds(arg_0));
        maxQueueSize.ifPresent(arg_0 -> ((PoolingOptions)result).setMaxQueueSize(arg_0));
        return Optional.of(result);
    }

    public ClusterConfiguration(List<Host> hosts, boolean createKeyspace, int minDelay, int maxRetry, Optional<QueryLoggerConfiguration> queryLoggerConfiguration, Optional<PoolingOptions> poolingOptions, int readTimeoutMillis, int connectTimeoutMillis, boolean useSsl, Optional<String> username, Optional<String> password) {
        this.hosts = hosts;
        this.createKeyspace = createKeyspace;
        this.minDelay = minDelay;
        this.maxRetry = maxRetry;
        this.queryLoggerConfiguration = queryLoggerConfiguration;
        this.poolingOptions = poolingOptions;
        this.readTimeoutMillis = readTimeoutMillis;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.useSsl = useSsl;
        this.username = username;
        this.password = password;
    }

    public List<Host> getHosts() {
        return this.hosts;
    }

    public boolean shouldCreateKeyspace() {
        return this.createKeyspace;
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public Optional<QueryLoggerConfiguration> getQueryLoggerConfiguration() {
        return this.queryLoggerConfiguration;
    }

    public Optional<PoolingOptions> getPoolingOptions() {
        return this.poolingOptions;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    public final boolean equals(Object o) {
        if (o instanceof ClusterConfiguration) {
            ClusterConfiguration that = (ClusterConfiguration)o;
            return Objects.equals(this.minDelay, that.minDelay) && Objects.equals(this.maxRetry, that.maxRetry) && Objects.equals(this.hosts, that.hosts) && Objects.equals(this.createKeyspace, that.createKeyspace) && Objects.equals(this.queryLoggerConfiguration, that.queryLoggerConfiguration) && Objects.equals(this.poolingOptions, that.poolingOptions) && Objects.equals(this.readTimeoutMillis, that.readTimeoutMillis) && Objects.equals(this.connectTimeoutMillis, that.connectTimeoutMillis) && Objects.equals(this.useSsl, that.useSsl) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.hosts, this.createKeyspace, this.minDelay, this.maxRetry, this.queryLoggerConfiguration, this.poolingOptions, this.readTimeoutMillis, this.connectTimeoutMillis, this.username, this.useSsl, this.password);
    }

    public static class Builder {
        private ImmutableList.Builder<Host> hosts = ImmutableList.builder();
        private boolean createKeyspace = false;
        private Optional<Integer> minDelay = Optional.empty();
        private Optional<Integer> maxRetry = Optional.empty();
        private Optional<QueryLoggerConfiguration> queryLoggerConfiguration = Optional.empty();
        private Optional<PoolingOptions> poolingOptions = Optional.empty();
        private Optional<Integer> readTimeoutMillis = Optional.empty();
        private Optional<Integer> connectTimeoutMillis = Optional.empty();
        private Optional<Boolean> useSsl;
        private Optional<String> username = Optional.empty();
        private Optional<String> password = Optional.empty();

        public Builder() {
            this.useSsl = Optional.empty();
        }

        public Builder host(Host host) {
            this.hosts.add((Object)host);
            return this;
        }

        public Builder hosts(Collection<Host> hosts) {
            this.hosts.addAll(hosts);
            return this;
        }

        public Builder hosts(Host ... hosts) {
            this.hosts.addAll(Arrays.asList(hosts));
            return this;
        }

        public Builder createKeyspace() {
            this.createKeyspace = true;
            return this;
        }

        public Builder minDelay(Optional<Integer> minDelay) {
            this.minDelay = minDelay;
            return this;
        }

        public Builder minDelay(int minDelay) {
            return this.minDelay(Optional.of(minDelay));
        }

        public Builder maxRetry(Optional<Integer> maxRetry) {
            this.maxRetry = maxRetry;
            return this;
        }

        public Builder maxRetry(int maxRetry) {
            return this.maxRetry(Optional.of(maxRetry));
        }

        public Builder queryLoggerConfiguration(QueryLoggerConfiguration queryLoggerConfiguration) {
            this.queryLoggerConfiguration = Optional.of(queryLoggerConfiguration);
            return this;
        }

        public Builder poolingOptions(Optional<PoolingOptions> poolingOptions) {
            this.poolingOptions = poolingOptions;
            return this;
        }

        public Builder poolingOptions(PoolingOptions poolingOptions) {
            return this.poolingOptions(Optional.of(poolingOptions));
        }

        public Builder readTimeoutMillis(Optional<Integer> readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder readTimeoutMillis(int readTimeoutMillis) {
            return this.readTimeoutMillis(Optional.of(readTimeoutMillis));
        }

        public Builder connectTimeoutMillis(Optional<Integer> connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public Builder username(Optional<String> username) {
            this.username = username;
            return this;
        }

        public Builder username(String username) {
            return this.username(Optional.of(username));
        }

        public Builder password(Optional<String> password) {
            this.password = password;
            return this;
        }

        public Builder password(String password) {
            return this.password(Optional.of(password));
        }

        public Builder useSsl(Optional<Boolean> useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder useSsl(boolean useSsl) {
            return this.useSsl(Optional.of(useSsl));
        }

        public Builder useSsl() {
            return this.useSsl(true);
        }

        public Builder connectTimeoutMillis(int connectTimeoutMillis) {
            return this.connectTimeoutMillis(Optional.of(connectTimeoutMillis));
        }

        public ClusterConfiguration build() {
            return new ClusterConfiguration((List<Host>)this.hosts.build(), this.createKeyspace, this.minDelay.orElse(5000), this.maxRetry.orElse(10), this.queryLoggerConfiguration, this.poolingOptions, this.readTimeoutMillis.orElse(5000), this.connectTimeoutMillis.orElse(5000), this.useSsl.orElse(false), this.username, this.password);
        }
    }
}

