/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.PagingIterable;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.components.CassandraTable;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CassandraTableManager {
    private final Session session;
    private final CassandraModule module;

    @Inject
    public CassandraTableManager(CassandraModule module, Session session) {
        this.session = session;
        this.module = module;
    }

    public CassandraTable.InitializationStatus initializeTables() {
        KeyspaceMetadata keyspaceMetadata = this.session.getCluster().getMetadata().getKeyspace(this.session.getLoggedKeyspace());
        return this.module.moduleTables().stream().map(table -> table.initialize(keyspaceMetadata, this.session)).reduce((left, right) -> left.reduce((CassandraTable.InitializationStatus)((Object)right))).orElse(CassandraTable.InitializationStatus.ALREADY_DONE);
    }

    public void clearAllTables() {
        CassandraAsyncExecutor executor = new CassandraAsyncExecutor(this.session);
        Flux.fromIterable(this.module.moduleTables()).publishOn(Schedulers.elastic()).map(CassandraTable::getName).flatMap(name -> this.truncate(executor, (String)name), 16).then().block();
    }

    private Mono<Void> truncate(CassandraAsyncExecutor executor, String name) {
        return executor.execute(QueryBuilder.select().from(name).limit(1).setFetchSize(1)).filter(Predicate.not(PagingIterable::isExhausted)).flatMap(ignored -> executor.executeVoid((Statement)QueryBuilder.truncate((String)name)));
    }
}

