/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Joiner;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.sieverepository.api.SieveQuotaRepository;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"SieveQuota"})
@Path(value="/sieve/quota")
@Produces(value={"application/json"})
public class SieveQuotaRoutes
implements Routes {
    public static final String ROOT_PATH = "/sieve/quota";
    public static final String DEFAULT_QUOTA_PATH = "/sieve/quota/default";
    private static final String USER_ID = "userId";
    private static final String USER_SIEVE_QUOTA_PATH = Joiner.on((String)"/").join((Object)"/sieve/quota", (Object)"users", new Object[]{":userId"});
    private static final String REQUESTED_SIZE = "requestedSize";
    private final SieveQuotaRepository sieveQuotaRepository;
    private final UsersRepository usersRepository;
    private final JsonTransformer jsonTransformer;

    @Inject
    public SieveQuotaRoutes(SieveQuotaRepository sieveQuotaRepository, UsersRepository usersRepository, JsonTransformer jsonTransformer) {
        this.sieveQuotaRepository = sieveQuotaRepository;
        this.usersRepository = usersRepository;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        this.defineGetGlobalSieveQuota(service);
        this.defineUpdateGlobalSieveQuota(service);
        this.defineRemoveGlobalSieveQuota(service);
        this.defineGetPerUserSieveQuota(service);
        this.defineUpdatePerUserSieveQuota(service);
        this.defineRemovePerUserSieveQuota(service);
    }

    @GET
    @ApiOperation(value="Reading global sieve quota size")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Long.class), @ApiResponse(code=204, message="Global sieve quota not set."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetGlobalSieveQuota(Service service) {
        service.get(DEFAULT_QUOTA_PATH, (request, response) -> {
            try {
                QuotaSizeLimit sieveQuota = this.sieveQuotaRepository.getDefaultQuota();
                response.status(200);
                return sieveQuota.asLong();
            }
            catch (QuotaNotFoundException e) {
                return Responses.returnNoContent((Response)response);
            }
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @PUT
    @ApiOperation(value="Update global sieve quota size")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="long", name="requestedSize", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Long.class), @ApiResponse(code=400, message="The body is not a positive integer."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateGlobalSieveQuota(Service service) {
        service.put(DEFAULT_QUOTA_PATH, (request, response) -> {
            QuotaSizeLimit requestedSize = this.extractRequestedQuotaSizeFromRequest(request);
            this.sieveQuotaRepository.setDefaultQuota(requestedSize);
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @DELETE
    @ApiOperation(value="Removes global sieve quota")
    @ApiResponses(value={@ApiResponse(code=204, message="Global sieve quota removed."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineRemoveGlobalSieveQuota(Service service) {
        service.delete(DEFAULT_QUOTA_PATH, (request, response) -> {
            try {
                this.sieveQuotaRepository.removeQuota();
            }
            catch (QuotaNotFoundException quotaNotFoundException) {
                // empty catch block
            }
            return Responses.returnNoContent((Response)response);
        });
    }

    @GET
    @Path(value="/sieve/quota/{userId}")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="userId", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Long.class), @ApiResponse(code=204, message="User sieve quota not set."), @ApiResponse(code=404, message="The user name does not exist"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetPerUserSieveQuota(Service service) {
        service.get(USER_SIEVE_QUOTA_PATH, (request, response) -> {
            Username userId = this.getUsername(request.params(USER_ID));
            try {
                QuotaSizeLimit userQuota = this.sieveQuotaRepository.getQuota(userId);
                response.status(200);
                return userQuota.asLong();
            }
            catch (QuotaNotFoundException e) {
                return Responses.returnNoContent((Response)response);
            }
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @PUT
    @Path(value="/sieve/quota/{userId}")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="userId", paramType="path"), @ApiImplicitParam(required=true, dataType="long", name="requestedSize", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK", response=Long.class), @ApiResponse(code=400, message="The body is not a positive integer."), @ApiResponse(code=404, message="The user name does not exist"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdatePerUserSieveQuota(Service service) {
        service.put(USER_SIEVE_QUOTA_PATH, (request, response) -> {
            Username userId = this.getUsername(request.params(USER_ID));
            QuotaSizeLimit requestedSize = this.extractRequestedQuotaSizeFromRequest(request);
            this.sieveQuotaRepository.setQuota(userId, requestedSize);
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @DELETE
    @Path(value="/sieve/quota/{userId}")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="userId", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="User sieve quota removed."), @ApiResponse(code=404, message="The user name does not exist"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineRemovePerUserSieveQuota(Service service) {
        service.delete(USER_SIEVE_QUOTA_PATH, (request, response) -> {
            Username usernameId = this.getUsername(request.params(USER_ID));
            try {
                this.sieveQuotaRepository.removeQuota(usernameId);
            }
            catch (QuotaNotFoundException quotaNotFoundException) {
                // empty catch block
            }
            return Responses.returnNoContent((Response)response);
        });
    }

    private QuotaSizeLimit extractRequestedQuotaSizeFromRequest(Request request) {
        long requestedSize = this.extractNumberFromRequestBody(request);
        if (requestedSize < 0L) {
            throw ErrorResponder.builder().type(ErrorResponder.ErrorType.INVALID_ARGUMENT).statusCode(400).message("Requested quota size have to be a positive integer").haltError();
        }
        return QuotaSizeLimit.size((long)requestedSize);
    }

    private long extractNumberFromRequestBody(Request request) {
        String body = request.body();
        try {
            return Long.parseLong(body);
        }
        catch (NumberFormatException e) {
            throw ErrorResponder.builder().type(ErrorResponder.ErrorType.INVALID_ARGUMENT).statusCode(400).message("unrecognized integer number '%s'", new Object[]{body}).haltError();
        }
    }

    private Username getUsername(String usernameParameter) throws UsersRepositoryException {
        Username username = Username.of((String)usernameParameter);
        if (!this.usersRepository.contains(username)) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("User %s does not exist", new Object[]{username}).haltError();
        }
        return username;
    }
}

