/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableListMultimap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.MappingValueDTO;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"Mappings"})
@Path(value="/mappings")
@Produces(value={"application/json"})
public class MappingRoutes
implements Routes {
    static final String BASE_PATH = "/mappings";
    static final String USER_MAPPING_PATH = "/mappings/user/";
    static final String USER = "user";
    private final JsonTransformer jsonTransformer;
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    MappingRoutes(JsonTransformer jsonTransformer, RecipientRewriteTable recipientRewriteTable) {
        this.jsonTransformer = jsonTransformer;
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        service.get(BASE_PATH, this::getMappings, (ResponseTransformer)this.jsonTransformer);
        service.get("/mappings/user/:user", this::getUserMappings, (ResponseTransformer)this.jsonTransformer);
    }

    @GET
    @Path(value="/mappings")
    @ApiOperation(value="Getting all mappings in RecipientRewriteTable")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class)})
    private ImmutableListMultimap<String, MappingValueDTO> getMappings(Request request, Response response) {
        try {
            return (ImmutableListMultimap)this.recipientRewriteTable.getAllMappings().entrySet().stream().flatMap(entry -> ((Mappings)entry.getValue()).asStream().map(mapping -> Pair.of((Object)((MappingSource)entry.getKey()).asString(), (Object)MappingValueDTO.fromMapping(mapping)))).collect(Guavate.toImmutableListMultimap(Pair::getLeft, Pair::getRight));
        }
        catch (RecipientRewriteTableException e) {
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(e.getMessage()).haltError();
        }
    }

    @GET
    @Path(value="/mappings/user/{user}")
    @ApiOperation(value="Getting all user mappings in RecipientRewriteTable")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=400, message="Invalid user parameter values.")})
    private List<MappingValueDTO> getUserMappings(Request request, Response response) throws RecipientRewriteTableException {
        Username username = Username.of((String)request.params(USER).toLowerCase());
        return (List)this.recipientRewriteTable.getStoredMappings(MappingSource.fromUser((Username)username)).asStream().map(mapping -> MappingValueDTO.fromMapping(mapping)).collect(Guavate.toImmutableList());
    }
}

