/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.rrt.api.LoopDetectedException;
import org.apache.james.rrt.api.MappingAlreadyExistsException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SameSourceAndDestinationException;
import org.apache.james.rrt.api.SourceDomainIsNotInDomainListException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.AliasSourcesResponse;
import org.apache.james.webadmin.routes.MailAddressParser;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

@Api(tags={"Address Aliases"})
@Path(value="address/aliases")
@Produces(value={"application/json"})
public class AliasRoutes
implements Routes {
    public static final String ROOT_PATH = "address/aliases";
    private static final String ALIAS_DESTINATION_ADDRESS = "aliasDestinationAddress";
    private static final String ALIAS_ADDRESS_PATH = "address/aliases/:aliasDestinationAddress";
    private static final String ALIAS_SOURCE_ADDRESS = "aliasSourceAddress";
    private static final String USER_IN_ALIAS_SOURCES_ADDRESSES_PATH = "address/aliases/:aliasDestinationAddress/sources/:aliasSourceAddress";
    private static final String MAILADDRESS_ASCII_DISCLAIMER = "Note that email addresses are restricted to ASCII character set. Mail addresses not matching this criteria will be rejected.";
    private static final String ADDRESS_TYPE = "alias";
    private final UsersRepository usersRepository;
    private final DomainList domainList;
    private final JsonTransformer jsonTransformer;
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    @VisibleForTesting
    AliasRoutes(RecipientRewriteTable recipientRewriteTable, UsersRepository usersRepository, DomainList domainList, JsonTransformer jsonTransformer) {
        this.usersRepository = usersRepository;
        this.domainList = domainList;
        this.jsonTransformer = jsonTransformer;
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.get(ROOT_PATH, this::listAddressesWithAliases, (ResponseTransformer)this.jsonTransformer);
        service.get(ALIAS_ADDRESS_PATH, this::listAliasesOfAddress, (ResponseTransformer)this.jsonTransformer);
        service.put(USER_IN_ALIAS_SOURCES_ADDRESSES_PATH, this::addAlias);
        service.delete(USER_IN_ALIAS_SOURCES_ADDRESSES_PATH, this::deleteAlias);
    }

    @GET
    @Path(value="address/aliases")
    @ApiOperation(value="getting addresses containing aliases list")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public ImmutableSet<String> listAddressesWithAliases(Request request, Response response) throws RecipientRewriteTableException {
        return (ImmutableSet)this.recipientRewriteTable.getMappingsForType(Mapping.Type.Alias).flatMap(mapping -> mapping.asMailAddress().stream()).map(MailAddress::asString).collect(Guavate.toImmutableSortedSet());
    }

    @PUT
    @Path(value="address/aliases/{aliasDestinationAddress}/sources/{aliasSourceAddress}")
    @ApiOperation(value="adding a source address into an alias")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="aliasDestinationAddress", paramType="path", value="Destination mail address of the alias. Sending a mail to the alias source address will send it to that email address.\nNote that email addresses are restricted to ASCII character set. Mail addresses not matching this criteria will be rejected."), @ApiImplicitParam(required=true, dataType="string", name="aliasSourceAddress", paramType="path", value="Source mail address of the alias. Sending a mail to that address will send it to the email destination address.\nNote that email addresses are restricted to ASCII character set. Mail addresses not matching this criteria will be rejected.")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="aliasDestinationAddress or alias structure format is not valid"), @ApiResponse(code=400, message="The alias source exists as an user already"), @ApiResponse(code=400, message="Source and destination can't be the same!"), @ApiResponse(code=400, message="Domain in the destination or source is not managed by the DomainList"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public HaltException addAlias(Request request, Response response) throws UsersRepositoryException, RecipientRewriteTableException, DomainListException {
        MailAddress aliasSourceAddress = MailAddressParser.parseMailAddress(request.params(ALIAS_SOURCE_ADDRESS), ADDRESS_TYPE);
        this.ensureUserDoesNotExist(aliasSourceAddress);
        MailAddress destinationAddress = MailAddressParser.parseMailAddress(request.params(ALIAS_DESTINATION_ADDRESS), ADDRESS_TYPE);
        this.ensureDomainIsSupported(destinationAddress.getDomain());
        MappingSource source = MappingSource.fromUser((Username)Username.fromMailAddress((MailAddress)aliasSourceAddress));
        this.addAlias(source, destinationAddress);
        return Spark.halt((int)204);
    }

    private void addAlias(MappingSource source, MailAddress aliasSourceAddress) throws RecipientRewriteTableException {
        try {
            this.recipientRewriteTable.addAliasMapping(source, aliasSourceAddress.asString());
        }
        catch (MappingAlreadyExistsException mappingAlreadyExistsException) {
        }
        catch (SameSourceAndDestinationException | SourceDomainIsNotInDomainListException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(e.getMessage()).haltError();
        }
        catch (LoopDetectedException e) {
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.WRONG_STATE).message(e.getMessage()).haltError();
        }
    }

    private void ensureDomainIsSupported(Domain domain) throws DomainListException {
        if (!this.domainList.containsDomain(domain)) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Domain in the destination is not managed by the DomainList").haltError();
        }
    }

    private void ensureUserDoesNotExist(MailAddress mailAddress) throws UsersRepositoryException {
        Username username = this.usersRepository.getUsername(mailAddress);
        if (this.usersRepository.contains(username)) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The alias source exists as an user already").haltError();
        }
    }

    @DELETE
    @Path(value="address/aliases/{aliasDestinationAddress}/sources/{aliasSourceAddress}")
    @ApiOperation(value="remove an alias from a destination address")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="aliasDestinationAddress", paramType="path", value="Destination mail address of the alias to remove.\nNote that email addresses are restricted to ASCII character set. Mail addresses not matching this criteria will be rejected."), @ApiImplicitParam(required=true, dataType="string", name="aliasSourceAddress", paramType="path", value="Source mail address of the alias to remove.\nNote that email addresses are restricted to ASCII character set. Mail addresses not matching this criteria will be rejected.")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="aliasDestinationAddress or alias structure format is not valid"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public HaltException deleteAlias(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress destinationAddress = MailAddressParser.parseMailAddress(request.params(ALIAS_DESTINATION_ADDRESS), ADDRESS_TYPE);
        MailAddress aliasToBeRemoved = MailAddressParser.parseMailAddress(request.params(ALIAS_SOURCE_ADDRESS), ADDRESS_TYPE);
        MappingSource source = MappingSource.fromMailAddress((MailAddress)aliasToBeRemoved);
        this.recipientRewriteTable.removeAliasMapping(source, destinationAddress.asString());
        return Spark.halt((int)204);
    }

    @GET
    @Path(value="address/aliases/{aliasDestinationAddress}")
    @ApiOperation(value="listing alias sources of an address")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="aliasDestinationAddress", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=400, message="The destination is not an address"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public ImmutableSet<AliasSourcesResponse> listAliasesOfAddress(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress destinationAddress = MailAddressParser.parseMailAddress(request.params(ALIAS_DESTINATION_ADDRESS), ADDRESS_TYPE);
        return (ImmutableSet)this.recipientRewriteTable.listSources(Mapping.alias((String)destinationAddress.asString())).sorted(Comparator.comparing(MappingSource::asMailAddressString)).map(AliasSourcesResponse::new).collect(Guavate.toImmutableSet());
    }
}

