/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.modules.protocols.Pop3GuiceProbe;
import org.apache.james.pop3server.netty.OioPOP3ServerFactory;
import org.apache.james.pop3server.netty.POP3ServerFactory;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class POP3ServerModule
extends AbstractModule {
    protected void configure() {
        this.bind(POP3ServerFactory.class).in(Scopes.SINGLETON);
        this.bind(OioPOP3ServerFactory.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(Pop3GuiceProbe.class);
    }

    @ProvidesIntoSet
    InitializationOperation configurePop3(ConfigurationProvider configurationProvider, POP3ServerFactory pop3ServerFactory) {
        return InitilizationOperationBuilder.forClass(POP3ServerFactory.class).init(() -> {
            pop3ServerFactory.configure(configurationProvider.getConfiguration("pop3server"));
            pop3ServerFactory.init();
        });
    }
}

