/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMetricsModule
extends AbstractModule {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"org.apache.james.metrics");

    protected void configure() {
        this.bind(StartableSlf4jReporter.class).in(Scopes.SINGLETON);
    }

    @ProvidesIntoSet
    InitializationOperation startReporter(StartableSlf4jReporter instance) {
        return InitilizationOperationBuilder.forClass(StartableSlf4jReporter.class).init(() -> instance.start());
    }

    @Singleton
    private static class StartableSlf4jReporter
    implements Startable {
        private final Slf4jReporter reporter;
        private boolean enableLogMetrics;

        @Inject
        StartableSlf4jReporter(MetricRegistry registry) {
            this.reporter = Slf4jReporter.forRegistry((MetricRegistry)registry).outputTo(LOGGER).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        }

        private void start() {
            this.enableLogMetrics = LOGGER.isDebugEnabled();
            if (this.enableLogMetrics) {
                int reportingPeriod = 10;
                this.reporter.start((long)reportingPeriod, TimeUnit.SECONDS);
            }
        }

        @PreDestroy
        public void close() {
            if (this.enableLogMetrics) {
                this.reporter.close();
            }
        }
    }
}

