/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class ClearMailRepositoryTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"clear-mail-repository");
    private final List<MailRepository> mailRepositories;
    private final MailRepositoryPath mailRepositoryPath;
    private final long initialCount;

    public ClearMailRepositoryTask(List<MailRepository> mailRepositories, MailRepositoryPath path) {
        this.mailRepositories = mailRepositories;
        this.mailRepositoryPath = path;
        this.initialCount = this.getRemainingSize();
    }

    public Task.Result run() {
        try {
            this.removeAllInAllRepositories();
            return Task.Result.COMPLETED;
        }
        catch (MessagingException e) {
            LOGGER.error("Encountered error while clearing repository", (Throwable)e);
            return Task.Result.PARTIAL;
        }
    }

    private void removeAllInAllRepositories() throws MessagingException {
        this.mailRepositories.forEach(Throwing.consumer(MailRepository::removeAll));
    }

    public TaskType type() {
        return TYPE;
    }

    MailRepositoryPath getMailRepositoryPath() {
        return this.mailRepositoryPath;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.mailRepositoryPath, this.initialCount, this.getRemainingSize(), Clock.systemUTC().instant()));
    }

    public long getRemainingSize() {
        return this.mailRepositories.stream().map(Throwing.function(MailRepository::size).sneakyThrow()).mapToLong(Long::valueOf).sum();
    }

    public static class InvalidMailRepositoryPathDeserializationException
    extends RuntimeException {
        public InvalidMailRepositoryPathDeserializationException(String mailRepositoryPath) {
            super("Unable to deserialize: '" + mailRepositoryPath + "' can not be url decoded");
        }
    }

    public static class UrlEncodingFailureSerializationException
    extends RuntimeException {
        public UrlEncodingFailureSerializationException(MailRepositoryPath mailRepositoryPath) {
            super("Unable to serialize: '" + mailRepositoryPath.asString() + "' can not be url encoded");
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailRepositoryPath repositoryPath;
        private final long initialCount;
        private final long remainingCount;
        private final Instant timestamp;

        public AdditionalInformation(MailRepositoryPath repositoryPath, long initialCount, long remainingCount, Instant timestamp) {
            this.repositoryPath = repositoryPath;
            this.initialCount = initialCount;
            this.remainingCount = remainingCount;
            this.timestamp = timestamp;
        }

        public String getRepositoryPath() {
            return this.repositoryPath.asString();
        }

        public long getRemainingCount() {
            return this.remainingCount;
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class Factory {
        private final MailRepositoryStore mailRepositoryStore;

        @Inject
        public Factory(MailRepositoryStore mailRepositoryStore) {
            this.mailRepositoryStore = mailRepositoryStore;
        }

        public ClearMailRepositoryTask create(MailRepositoryPath mailRepositoryPath) throws MailRepositoryStore.MailRepositoryStoreException {
            List mailRepositories = (List)this.mailRepositoryStore.getByPath(mailRepositoryPath).collect(Guavate.toImmutableList());
            return new ClearMailRepositoryTask(mailRepositories, mailRepositoryPath);
        }
    }
}

