/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import org.apache.james.events.EventBusId;
import org.apache.james.events.Group;
import org.apache.james.events.GroupConsumerRetry;
import org.apache.james.events.GroupRegistration;
import org.apache.james.events.RegistrationQueueName;
import reactor.rabbitmq.QueueSpecification;

public class NamingStrategy {
    private final String prefix;

    public NamingStrategy(String prefix) {
        this.prefix = prefix;
    }

    public RegistrationQueueName queueName(EventBusId eventBusId) {
        return new RegistrationQueueName(this.prefix + "-eventbus-" + eventBusId.asString());
    }

    public QueueSpecification deadLetterQueue() {
        return QueueSpecification.queue((String)(this.prefix + "-dead-letter-queue"));
    }

    public String exchange() {
        return this.prefix + "-exchange";
    }

    public String deadLetterExchange() {
        return this.prefix + "-dead-letter-exchange";
    }

    public GroupConsumerRetry.RetryExchangeName retryExchange(Group group) {
        return new GroupConsumerRetry.RetryExchangeName(this.prefix, group);
    }

    public GroupRegistration.WorkQueueName workQueue(Group group) {
        return new GroupRegistration.WorkQueueName(this.prefix, group);
    }
}

