/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.james.events.EventListener;
import org.apache.james.events.RegistrationKey;
import reactor.core.publisher.Flux;

class LocalListenerRegistry {
    private final ConcurrentHashMap<RegistrationKey, ImmutableSet<EventListener.ReactiveEventListener>> listenersByKey = new ConcurrentHashMap();

    LocalListenerRegistry() {
    }

    LocalRegistration addListener(RegistrationKey registrationKey, EventListener.ReactiveEventListener listener) {
        AtomicBoolean firstListener = new AtomicBoolean(false);
        this.listenersByKey.compute(registrationKey, (key, listeners) -> Optional.ofNullable(listeners).map(set -> ImmutableSet.builder().addAll((Iterable)set).add((Object)listener).build()).orElseGet(() -> {
            firstListener.set(true);
            return ImmutableSet.of((Object)listener);
        }));
        return new LocalRegistration(firstListener.get(), () -> this.removeListener(registrationKey, listener));
    }

    LocalRegistration addListener(RegistrationKey registrationKey, EventListener listener) {
        return this.addListener(registrationKey, EventListener.wrapReactive((EventListener)listener));
    }

    private RemovalStatus removeListener(RegistrationKey registrationKey, EventListener.ReactiveEventListener listener) {
        AtomicBoolean lastListenerRemoved = new AtomicBoolean(false);
        this.listenersByKey.compute(registrationKey, (key, listeners) -> {
            boolean listenersContainRequested = Optional.ofNullable(listeners).orElse(ImmutableSet.of()).contains((Object)listener);
            if (listenersContainRequested) {
                ImmutableSet<EventListener.ReactiveEventListener> remainingListeners = this.removeListenerFromSet((EventListener)listener, (ImmutableSet<EventListener.ReactiveEventListener>)listeners);
                if (remainingListeners.isEmpty()) {
                    lastListenerRemoved.set(true);
                    return null;
                }
                return remainingListeners;
            }
            return listeners;
        });
        return lastListenerRemoved::get;
    }

    private ImmutableSet<EventListener.ReactiveEventListener> removeListenerFromSet(EventListener listener, ImmutableSet<EventListener.ReactiveEventListener> listeners) {
        ImmutableSet remainingListeners = (ImmutableSet)listeners.stream().filter(Predicates.not(listener::equals)).collect(Guavate.toImmutableSet());
        if (remainingListeners.isEmpty()) {
            return ImmutableSet.of();
        }
        return remainingListeners;
    }

    Flux<EventListener.ReactiveEventListener> getLocalListeners(RegistrationKey registrationKey) {
        return Flux.fromIterable((Iterable)((Iterable)this.listenersByKey.getOrDefault(registrationKey, (ImmutableSet<EventListener.ReactiveEventListener>)ImmutableSet.of())));
    }

    public static class LocalRegistration {
        private final boolean firstListener;
        private final Supplier<RemovalStatus> unregister;

        public LocalRegistration(boolean firstListener, Supplier<RemovalStatus> unregister) {
            this.firstListener = firstListener;
            this.unregister = unregister;
        }

        public boolean isFirstListener() {
            return this.firstListener;
        }

        public RemovalStatus unregister() {
            return this.unregister.get();
        }
    }

    static interface RemovalStatus {
        public boolean lastListenerRemoved();
    }
}

