/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.backends.rabbitmq.Constants;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.GroupConsumerRetry;
import org.apache.james.events.ListenerExecutor;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.Registration;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.events.WaitDelayGenerator;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.AcknowledgableDelivery;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ConsumeOptions;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.Sender;
import reactor.util.retry.Retry;

class GroupRegistration
implements Registration {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupRegistration.class);
    static final String RETRY_COUNT = "retry-count";
    static final int DEFAULT_RETRY_COUNT = 0;
    private final NamingStrategy namingStrategy;
    private final ReactorRabbitMQChannelPool channelPool;
    private final EventListener.ReactiveEventListener listener;
    private final WorkQueueName queueName;
    private final Receiver receiver;
    private final Runnable unregisterGroup;
    private final Sender sender;
    private final EventSerializer eventSerializer;
    private final GroupConsumerRetry retryHandler;
    private final WaitDelayGenerator delayGenerator;
    private final Group group;
    private final RetryBackoffConfiguration retryBackoff;
    private final ListenerExecutor listenerExecutor;
    private Optional<Disposable> receiverSubscriber;

    GroupRegistration(NamingStrategy namingStrategy, ReactorRabbitMQChannelPool channelPool, Sender sender, ReceiverProvider receiverProvider, EventSerializer eventSerializer, EventListener.ReactiveEventListener listener, Group group, RetryBackoffConfiguration retryBackoff, EventDeadLetters eventDeadLetters, Runnable unregisterGroup, ListenerExecutor listenerExecutor) {
        this.namingStrategy = namingStrategy;
        this.channelPool = channelPool;
        this.eventSerializer = eventSerializer;
        this.listener = listener;
        this.queueName = namingStrategy.workQueue(group);
        this.sender = sender;
        this.receiver = receiverProvider.createReceiver();
        this.retryBackoff = retryBackoff;
        this.listenerExecutor = listenerExecutor;
        this.receiverSubscriber = Optional.empty();
        this.unregisterGroup = unregisterGroup;
        this.retryHandler = new GroupConsumerRetry(namingStrategy, sender, group, retryBackoff, eventDeadLetters, eventSerializer);
        this.delayGenerator = WaitDelayGenerator.of(retryBackoff);
        this.group = group;
    }

    GroupRegistration start() {
        this.receiverSubscriber = Optional.of((Disposable)this.createGroupWorkQueue().then(this.retryHandler.createRetryExchange(this.queueName)).then(Mono.fromCallable(() -> this.consumeWorkQueue())).retryWhen((Retry)Retry.backoff((long)this.retryBackoff.getMaxRetries(), (Duration)this.retryBackoff.getFirstBackoff()).jitter(this.retryBackoff.getJitterFactor()).scheduler(Schedulers.elastic())).block());
        return this;
    }

    private Mono<Void> createGroupWorkQueue() {
        return this.channelPool.createWorkQueue(QueueSpecification.queue((String)this.queueName.asString()).durable(true).exclusive(false).autoDelete(false).arguments((Map)Constants.deadLetterQueue((String)this.namingStrategy.deadLetterExchange())), BindingSpecification.binding().exchange(this.namingStrategy.exchange()).queue(this.queueName.asString()).routingKey(""));
    }

    private Disposable consumeWorkQueue() {
        return this.receiver.consumeManualAck(this.queueName.asString(), new ConsumeOptions().qos(10)).publishOn(Schedulers.parallel()).filter(delivery -> Objects.nonNull(delivery.getBody())).flatMap(this::deliver, 10).subscribe();
    }

    private Mono<Void> deliver(AcknowledgableDelivery acknowledgableDelivery) {
        byte[] eventAsBytes = acknowledgableDelivery.getBody();
        int currentRetryCount = this.getRetryCount(acknowledgableDelivery);
        return this.deserializeEvent(eventAsBytes).flatMap(event -> this.delayGenerator.delayIfHaveTo(currentRetryCount).flatMap(any -> this.runListener((Event)event)).onErrorResume(throwable -> this.retryHandler.handleRetry((Event)event, currentRetryCount, (Throwable)throwable)).then(Mono.fromRunnable(() -> ((AcknowledgableDelivery)acknowledgableDelivery).ack()))).onErrorResume(e -> {
            LOGGER.error("Unable to process delivery for group {}", (Object)this.group, e);
            return Mono.fromRunnable(() -> acknowledgableDelivery.nack(false));
        });
    }

    private Mono<Event> deserializeEvent(byte[] eventAsBytes) {
        return Mono.fromCallable(() -> this.eventSerializer.asEvent(new String(eventAsBytes, StandardCharsets.UTF_8))).subscribeOn(Schedulers.parallel());
    }

    Mono<Void> reDeliver(Event event) {
        return this.retryHandler.retryOrStoreToDeadLetter(event, 0);
    }

    private Mono<Void> runListener(Event event) {
        return this.listenerExecutor.execute(this.listener, MDCBuilder.create().addContext("group", (Object)this.group), event);
    }

    private int getRetryCount(AcknowledgableDelivery acknowledgableDelivery) {
        return Optional.ofNullable(acknowledgableDelivery.getProperties().getHeaders()).flatMap(headers -> Optional.ofNullable(headers.get(RETRY_COUNT))).filter(object -> object instanceof Integer).map(Integer.class::cast).orElse(0);
    }

    public void unregister() {
        this.receiverSubscriber.filter(Predicate.not(Disposable::isDisposed)).ifPresent(Disposable::dispose);
        this.receiver.close();
        this.unregisterGroup.run();
    }

    static class WorkQueueName {
        private final String prefix;
        private final Group group;

        WorkQueueName(String prefix, Group group) {
            this.prefix = prefix;
            Preconditions.checkNotNull((Object)group, (Object)"Group must be specified");
            this.group = group;
        }

        String asString() {
            return this.prefix + "-workQueue-" + this.group.asString();
        }
    }
}

