/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.MetadataWithMailboxId;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.DeleteResult;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageMovesWithMailbox;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.FetchGroupConverter;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.FlagsFactory;
import org.apache.james.mailbox.store.mail.model.FlagsFilter;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.quota.QuotaChecker;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class StoreMessageIdManager
implements MessageIdManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMessageIdManager.class);
    private final RightManager rightManager;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final EventBus eventBus;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final PreDeletionHooks preDeletionHooks;

    public static ImmutableSet<MailboxId> toMailboxIds(List<MailboxMessage> mailboxMessages) {
        return (ImmutableSet)mailboxMessages.stream().map(MailboxMessage::getMailboxId).collect(Guavate.toImmutableSet());
    }

    @Inject
    public StoreMessageIdManager(RightManager rightManager, MailboxSessionMapperFactory mailboxSessionMapperFactory, EventBus eventBus, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, PreDeletionHooks preDeletionHooks) {
        this.rightManager = rightManager;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.eventBus = eventBus;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.preDeletionHooks = preDeletionHooks;
    }

    public void setFlags(Flags newState, MessageManager.FlagsUpdateMode replace, MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        int concurrency = 4;
        List targetMailboxes = (List)Flux.fromIterable(mailboxIds).flatMap(mailboxMapper::findMailboxById, concurrency).collect(Guavate.toImmutableList()).subscribeOn(Schedulers.elastic()).block();
        this.assertRightsOnMailboxes(targetMailboxes, mailboxSession, MailboxACL.Right.Write);
        Multimap<MailboxId, UpdatedFlags> updatedFlags = messageIdMapper.setFlags(messageId, mailboxIds, newState, replace);
        for (Map.Entry entry : updatedFlags.asMap().entrySet()) {
            this.dispatchFlagsChange(mailboxSession, (MailboxId)entry.getKey(), (ImmutableList<UpdatedFlags>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())), targetMailboxes);
        }
    }

    public Set<MessageId> accessibleMessages(Collection<MessageId> messageIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        ImmutableList idList = (ImmutableList)Flux.fromIterable(messageIds).flatMap(messageIdMapper::findMetadata, 16).collect(Guavate.toImmutableList()).block();
        ImmutableSet<MailboxId> allowedMailboxIds = this.getAllowedMailboxIds(mailboxSession, idList.stream().map(id -> id.getComposedMessageId().getMailboxId()), MailboxACL.Right.Read);
        return (Set)idList.stream().filter(id -> allowedMailboxIds.contains((Object)id.getComposedMessageId().getMailboxId())).map(id -> id.getComposedMessageId().getMessageId()).collect(Guavate.toImmutableSet());
    }

    public List<MessageResult> getMessages(Collection<MessageId> messageIds, FetchGroup fetchGroup, MailboxSession mailboxSession) {
        return (List)this.getMessagesReactive(messageIds, fetchGroup, mailboxSession).collectList().block();
    }

    public Flux<MessageResult> getMessagesReactive(Collection<MessageId> messageIds, FetchGroup fetchGroup, MailboxSession mailboxSession) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MessageMapper.FetchType fetchType = FetchGroupConverter.getFetchType(fetchGroup);
        return messageIdMapper.findReactive(messageIds, fetchType).groupBy(MailboxMessage::getMailboxId).filterWhen(groupedFlux -> (Publisher)this.hasRightsOnMailboxReactive(mailboxSession, MailboxACL.Right.Read).apply((MailboxId)groupedFlux.key()), 16).flatMap(Function.identity(), 16).map(Throwing.function(this.messageResultConverter(fetchGroup)).sneakyThrow());
    }

    public Publisher<ComposedMessageIdWithMetaData> messagesMetadata(Collection<MessageId> ids, MailboxSession session) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(session);
        int concurrency = 4;
        return Flux.fromIterable(ids).flatMap(id -> Flux.from(messageIdMapper.findMetadata((MessageId)id)), concurrency).groupBy(metaData -> metaData.getComposedMessageId().getMailboxId()).filterWhen(groupedFlux -> (Publisher)this.hasRightsOnMailboxReactive(session, MailboxACL.Right.Read).apply((MailboxId)groupedFlux.key()), 16).flatMap(Function.identity(), 16);
    }

    private ImmutableSet<MailboxId> getAllowedMailboxIds(MailboxSession mailboxSession, Stream<MailboxId> idList, MailboxACL.Right ... rights) throws MailboxException {
        return (ImmutableSet)MailboxReactorUtils.block(Flux.fromStream(idList).distinct().filterWhen(this.hasRightsOnMailboxReactive(mailboxSession, rights), 16).collect(Guavate.toImmutableSet()));
    }

    public DeleteResult delete(MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MailboxReactorUtils.block(this.assertRightsOnMailboxIds(mailboxIds, mailboxSession, MailboxACL.Right.DeleteMessages));
        List messageList = (List)messageIdMapper.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Metadata).stream().filter(this.inMailboxes(mailboxIds)).collect(Guavate.toImmutableList());
        if (!messageList.isEmpty()) {
            this.deleteWithPreHooks(messageIdMapper, messageList, mailboxSession);
            return DeleteResult.destroyed((MessageId)messageId);
        }
        return DeleteResult.notFound((MessageId)messageId);
    }

    public DeleteResult delete(List<MessageId> messageIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        List<MailboxMessage> messageList = messageIdMapper.find(messageIds, MessageMapper.FetchType.Metadata);
        ImmutableSet<MailboxId> allowedMailboxIds = this.getAllowedMailboxIds(mailboxSession, messageList.stream().map(MailboxMessage::getMailboxId), MailboxACL.Right.DeleteMessages);
        List accessibleMessages = (List)messageList.stream().filter(message -> allowedMailboxIds.contains((Object)message.getMailboxId())).collect(Guavate.toImmutableList());
        ImmutableSet accessibleMessageIds = (ImmutableSet)accessibleMessages.stream().map(Message::getMessageId).distinct().collect(Guavate.toImmutableSet());
        Sets.SetView nonAccessibleMessages = Sets.difference((Set)ImmutableSet.copyOf(messageIds), (Set)accessibleMessageIds);
        this.deleteWithPreHooks(messageIdMapper, accessibleMessages, mailboxSession);
        return DeleteResult.builder().addDestroyed((Collection)accessibleMessageIds).addNotFound((Collection)nonAccessibleMessages).build();
    }

    private void deleteWithPreHooks(MessageIdMapper messageIdMapper, List<MailboxMessage> messageList, MailboxSession mailboxSession) throws MailboxException {
        ImmutableList metadataWithMailbox = (ImmutableList)messageList.stream().map(mailboxMessage -> MetadataWithMailboxId.from((MessageMetaData)mailboxMessage.metaData(), (MailboxId)mailboxMessage.getMailboxId())).collect(Guavate.toImmutableList());
        this.preDeletionHooks.runHooks(PreDeletionHook.DeleteOperation.from((List)metadataWithMailbox)).then(Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.delete(messageIdMapper, messageList, mailboxSession, (ImmutableList<MetadataWithMailboxId>)metadataWithMailbox)))).block();
    }

    private void delete(MessageIdMapper messageIdMapper, List<MailboxMessage> messageList, MailboxSession mailboxSession, ImmutableList<MetadataWithMailboxId> metadataWithMailbox) throws MailboxException {
        messageIdMapper.delete((Multimap<MessageId, MailboxId>)((Multimap)messageList.stream().collect(Guavate.toImmutableListMultimap(Message::getMessageId, MailboxMessage::getMailboxId))));
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        Flux.fromIterable(metadataWithMailbox).flatMap(metadataWithMailboxId -> mailboxMapper.findMailboxById(metadataWithMailboxId.getMailboxId()).flatMap(mailbox -> this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(mailboxSession)).mailbox((Mailbox)mailbox)).addMetaData(metadataWithMailboxId.getMessageMetaData())).build(), (RegistrationKey)new MailboxIdRegistrationKey(metadataWithMailboxId.getMailboxId()))), 16).then().subscribeOn(Schedulers.elastic()).block();
    }

    public void setInMailboxes(MessageId messageId, Collection<MailboxId> targetMailboxIds, MailboxSession mailboxSession) throws MailboxException {
        List<MailboxMessage> currentMailboxMessages = this.findRelatedMailboxMessages(messageId, mailboxSession);
        MailboxReactorUtils.block(this.messageMovesWithMailbox(MessageMoves.builder().targetMailboxIds(targetMailboxIds).previousMailboxIds(StoreMessageIdManager.toMailboxIds(currentMailboxMessages)).build(), mailboxSession).flatMap(Throwing.function(messageMove -> {
            MessageMovesWithMailbox refined = messageMove.filterPrevious(this.hasRightsOnMailbox(mailboxSession, MailboxACL.Right.Read));
            if (messageMove.getPreviousMailboxes().isEmpty()) {
                LOGGER.info("Tried to access {} not accessible for {}", (Object)messageId, (Object)mailboxSession.getUser().asString());
                return Mono.empty();
            }
            if (refined.isChange()) {
                return this.applyMessageMoves(mailboxSession, currentMailboxMessages, refined);
            }
            return Mono.empty();
        }).sneakyThrow()).subscribeOn(Schedulers.elastic()));
    }

    public void setInMailboxesNoCheck(MessageId messageId, MailboxId targetMailboxId, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        List<MailboxMessage> currentMailboxMessages = messageIdMapper.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Metadata);
        MailboxReactorUtils.block(this.messageMovesWithMailbox(MessageMoves.builder().targetMailboxIds(new MailboxId[]{targetMailboxId}).previousMailboxIds(StoreMessageIdManager.toMailboxIds(currentMailboxMessages)).build(), mailboxSession).flatMap(messageMove -> {
            if (messageMove.isChange()) {
                return this.applyMessageMoveNoMailboxChecks(mailboxSession, currentMailboxMessages, (MessageMovesWithMailbox)messageMove);
            }
            return Mono.empty();
        }).subscribeOn(Schedulers.elastic()));
    }

    private List<MailboxMessage> findRelatedMailboxMessages(MessageId messageId, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        return (List)MailboxReactorUtils.block(messageIdMapper.findReactive((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Metadata).collect(Guavate.toImmutableList()));
    }

    private Mono<Void> applyMessageMoves(MailboxSession mailboxSession, List<MailboxMessage> currentMailboxMessages, MessageMovesWithMailbox messageMoves) throws MailboxNotFoundException {
        this.assertRightsOnMailboxes(messageMoves.addedMailboxes(), mailboxSession, MailboxACL.Right.Insert);
        this.assertRightsOnMailboxes(messageMoves.removedMailboxes(), mailboxSession, MailboxACL.Right.DeleteMessages);
        this.assertRightsOnMailboxes((Collection<Mailbox>)messageMoves.getTargetMailboxes(), mailboxSession, MailboxACL.Right.Read);
        return this.applyMessageMoveNoMailboxChecks(mailboxSession, currentMailboxMessages, messageMoves);
    }

    private Mono<Void> applyMessageMoveNoMailboxChecks(MailboxSession mailboxSession, List<MailboxMessage> currentMailboxMessages, MessageMovesWithMailbox messageMoves) {
        Optional mailboxMessage = currentMailboxMessages.stream().findAny();
        if (mailboxMessage.isEmpty()) {
            return Mono.error((Throwable)new MailboxNotFoundException("can't load message"));
        }
        List messagesToRemove = (List)currentMailboxMessages.stream().flatMap(message -> messageMoves.removedMailboxes().stream().filter(mailbox -> mailbox.getMailboxId().equals(message.getMailboxId())).map(mailbox -> Pair.of((Object)message, (Object)mailbox))).collect(Guavate.toImmutableList());
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.validateQuota(messageMoves, (MailboxMessage)mailboxMessage.get())).sneakyThrow()).then(Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.addMessageToMailboxes((MailboxMessage)mailboxMessage.get(), messageMoves.addedMailboxes(), mailboxSession)).sneakyThrow())).then(this.removeMessageFromMailboxes(((MailboxMessage)mailboxMessage.get()).getMessageId(), messagesToRemove, mailboxSession)).then(this.eventBus.dispatch((Event)EventFactory.moved().session(mailboxSession).messageMoves(messageMoves.asMessageMoves()).messageId(((MailboxMessage)mailboxMessage.get()).getMessageId()).build(), (Set)messageMoves.impactedMailboxes().map(Mailbox::getMailboxId).map(MailboxIdRegistrationKey::new).collect(Guavate.toImmutableSet())));
    }

    private Mono<Void> removeMessageFromMailboxes(MessageId messageId, List<Pair<MailboxMessage, Mailbox>> messages, MailboxSession mailboxSession) {
        if (messages.isEmpty()) {
            return Mono.empty();
        }
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        ImmutableList mailboxIds = (ImmutableList)messages.stream().map(pair -> ((Mailbox)pair.getRight()).getMailboxId()).collect(Guavate.toImmutableList());
        return Mono.from(messageIdMapper.deleteReactive(messageId, (Collection<MailboxId>)mailboxIds)).then(Flux.fromIterable(messages).flatMap(message -> this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(mailboxSession)).mailbox((Mailbox)message.getRight())).addMetaData(((MailboxMessage)message.getLeft()).metaData())).build(), (RegistrationKey)new MailboxIdRegistrationKey(((Mailbox)message.getRight()).getMailboxId())), 16).then());
    }

    private void dispatchFlagsChange(MailboxSession mailboxSession, MailboxId mailboxId, ImmutableList<UpdatedFlags> updatedFlags, List<Mailbox> knownMailboxes) throws MailboxException {
        if (updatedFlags.stream().anyMatch(UpdatedFlags::flagsChanged)) {
            Mailbox mailbox = knownMailboxes.stream().filter(knownMailbox -> knownMailbox.getMailboxId().equals(mailboxId)).findFirst().orElseGet(Throwing.supplier(() -> (Mailbox)MailboxReactorUtils.block(this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).findMailboxById(mailboxId).subscribeOn(Schedulers.elastic()))).sneakyThrow());
            this.eventBus.dispatch((Event)((EventFactory.FlagsUpdatedFinalStage)((EventFactory.RequireUpdatedFlags)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.flagsUpdated().randomEventId()).mailboxSession(mailboxSession)).mailbox(mailbox)).updatedFlags(updatedFlags)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailboxId)).subscribeOn(Schedulers.elastic()).block();
        }
    }

    private void validateQuota(MessageMovesWithMailbox messageMoves, MailboxMessage mailboxMessage) throws MailboxException {
        Map<QuotaRoot, Integer> messageCountByQuotaRoot = this.buildMapQuotaRoot(messageMoves);
        for (Map.Entry<QuotaRoot, Integer> entry : messageCountByQuotaRoot.entrySet()) {
            Integer additionalCopyCount = entry.getValue();
            if (additionalCopyCount <= 0) continue;
            long additionalOccupiedSpace = (long)additionalCopyCount.intValue() * mailboxMessage.getFullContentOctets();
            new QuotaChecker(this.quotaManager.getQuotas(entry.getKey()), entry.getKey()).tryAddition(additionalCopyCount.intValue(), additionalOccupiedSpace);
        }
    }

    private Map<QuotaRoot, Integer> buildMapQuotaRoot(MessageMovesWithMailbox messageMoves) throws MailboxException {
        int currentCount;
        QuotaRoot quotaRoot;
        HashMap<QuotaRoot, Integer> messageCountByQuotaRoot = new HashMap<QuotaRoot, Integer>();
        for (Mailbox mailbox : messageMoves.addedMailboxes()) {
            quotaRoot = this.quotaRootResolver.getQuotaRoot(mailbox);
            currentCount = Optional.ofNullable((Integer)messageCountByQuotaRoot.get(quotaRoot)).orElse(0);
            messageCountByQuotaRoot.put(quotaRoot, currentCount + 1);
        }
        for (Mailbox mailbox : messageMoves.removedMailboxes()) {
            quotaRoot = this.quotaRootResolver.getQuotaRoot(mailbox);
            currentCount = Optional.ofNullable((Integer)messageCountByQuotaRoot.get(quotaRoot)).orElse(0);
            messageCountByQuotaRoot.put(quotaRoot, currentCount - 1);
        }
        return messageCountByQuotaRoot;
    }

    private void addMessageToMailboxes(MailboxMessage mailboxMessage, Set<Mailbox> mailboxes, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        for (Mailbox mailbox : mailboxes) {
            MailboxACL.Rfc4314Rights myRights = this.rightManager.myRights(mailbox, mailboxSession);
            boolean shouldPreserveFlags = myRights.contains(MailboxACL.Right.Write);
            SimpleMailboxMessage copy = SimpleMailboxMessage.from(mailboxMessage).mailboxId(mailbox.getMailboxId()).flags(FlagsFactory.builder().flags(mailboxMessage.createFlags()).filteringFlags(FlagsFilter.builder().systemFlagFilter(f -> shouldPreserveFlags).userFlagFilter(f -> shouldPreserveFlags).build()).build()).build();
            this.save(messageIdMapper, copy, mailbox);
            this.eventBus.dispatch((Event)((EventFactory.AddedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(mailboxSession)).mailbox(mailbox)).addMetaData(copy.metaData())).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())).block();
        }
    }

    private void save(MessageIdMapper messageIdMapper, MailboxMessage mailboxMessage, Mailbox mailbox) throws MailboxException {
        ModSeq modSeq = this.mailboxSessionMapperFactory.getModSeqProvider().nextModSeq(mailbox.getMailboxId());
        MessageUid uid = this.mailboxSessionMapperFactory.getUidProvider().nextUid(mailbox.getMailboxId());
        mailboxMessage.setModSeq(modSeq);
        mailboxMessage.setUid(uid);
        messageIdMapper.copyInMailbox(mailboxMessage, mailbox);
    }

    private ThrowingFunction<MailboxMessage, MessageResult> messageResultConverter(FetchGroup fetchGroup) {
        return input -> ResultUtils.loadMessageResult(input, fetchGroup);
    }

    private Predicate<MailboxMessage> inMailboxes(Collection<MailboxId> mailboxIds) {
        return mailboxMessage -> mailboxIds.contains(mailboxMessage.getMailboxId());
    }

    private Function<MailboxId, Mono<Boolean>> hasRightsOnMailboxReactive(MailboxSession session, MailboxACL.Right ... rights) {
        return mailboxId -> Mono.from((Publisher)this.rightManager.myRights(mailboxId, session)).map(myRights -> myRights.contains(rights)).onErrorResume(any -> Mono.just((Object)false));
    }

    private Predicate<Mailbox> hasRightsOnMailbox(MailboxSession session, MailboxACL.Right ... rights) {
        return mailbox -> this.rightManager.myRights(mailbox, session).contains(rights);
    }

    private Mono<Void> assertRightsOnMailboxIds(Collection<MailboxId> mailboxIds, MailboxSession mailboxSession, MailboxACL.Right ... rights) {
        return Flux.fromIterable(mailboxIds).filterWhen(this.hasRightsOnMailboxReactive(mailboxSession, rights).andThen(result -> result.map(FunctionalUtils.negate())), 16).next().flatMap(mailboxForbidden -> {
            LOGGER.info("Mailbox with Id {} does not belong to {}", mailboxForbidden, (Object)mailboxSession.getUser().asString());
            return Mono.error((Throwable)new MailboxNotFoundException(mailboxForbidden));
        }).then();
    }

    private void assertRightsOnMailboxes(Collection<Mailbox> mailboxes, MailboxSession mailboxSession, MailboxACL.Right ... rights) throws MailboxNotFoundException {
        Optional<Mailbox> firstForbiddenMailbox = mailboxes.stream().filter(Predicate.not(this.hasRightsOnMailbox(mailboxSession, rights))).findFirst();
        if (firstForbiddenMailbox.isPresent()) {
            MailboxId mailboxId = firstForbiddenMailbox.get().getMailboxId();
            LOGGER.info("Mailbox with Id {} does not belong to {}", (Object)mailboxId, (Object)mailboxSession.getUser().asString());
            throw new MailboxNotFoundException(firstForbiddenMailbox.get().generateAssociatedPath());
        }
    }

    private Mono<MessageMovesWithMailbox> messageMovesWithMailbox(MessageMoves messageMoves, MailboxSession session) {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mono target = Flux.fromIterable((Iterable)messageMoves.getTargetMailboxIds()).flatMap(mailboxMapper::findMailboxById, 16).collect(Guavate.toImmutableList());
        Mono previous = Flux.fromIterable((Iterable)messageMoves.getPreviousMailboxIds()).flatMap(mailboxMapper::findMailboxById, 16).collect(Guavate.toImmutableList());
        return target.zipWith(previous).map(tuple -> MessageMovesWithMailbox.builder().targetMailboxes((Iterable)tuple.getT1()).previousMailboxes((Iterable)tuple.getT2()).build());
    }
}

