/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.james.transport.mailets.remote.delivery.Delay;
import org.apache.james.transport.mailets.remote.delivery.Repeat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelaysAndMaxRetry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelaysAndMaxRetry.class);
    private final int maxRetries;
    private final List<Delay> delays;

    public static DelaysAndMaxRetry defaults() {
        return new DelaysAndMaxRetry(5, Repeat.repeat(new Delay(), 5));
    }

    public static DelaysAndMaxRetry from(int intendedMaxRetries, String delaysAsString) throws MessagingException {
        List<Delay> delayTimesList = DelaysAndMaxRetry.createDelayList(delaysAsString);
        int totalAttempts = DelaysAndMaxRetry.computeTotalAttempts(delayTimesList);
        return DelaysAndMaxRetry.getDelaysAndMaxRetry(intendedMaxRetries, totalAttempts, delayTimesList);
    }

    private static DelaysAndMaxRetry getDelaysAndMaxRetry(int intendedMaxRetries, int totalAttempts, List<Delay> delayTimesList) throws MessagingException {
        if (totalAttempts > intendedMaxRetries) {
            LOGGER.warn("Total number of delayTime attempts exceeds maxRetries specified. Increasing maxRetries from {} to {}", (Object)intendedMaxRetries, (Object)totalAttempts);
            return new DelaysAndMaxRetry(totalAttempts, delayTimesList);
        }
        int extra = intendedMaxRetries - totalAttempts;
        if (extra > 0) {
            LOGGER.warn("maxRetries is larger than total number of attempts specified. Increasing last delayTime with {} attempts ", (Object)extra);
            return DelaysAndMaxRetry.addExtraAttemptToLastDelay(intendedMaxRetries, extra, delayTimesList);
        }
        return new DelaysAndMaxRetry(intendedMaxRetries, delayTimesList);
    }

    private static DelaysAndMaxRetry addExtraAttemptToLastDelay(int intendedMaxRetries, int extra, List<Delay> delayTimesList) throws MessagingException {
        if (delayTimesList.size() != 0) {
            Delay lastDelay = delayTimesList.get(delayTimesList.size() - 1);
            Duration lastDelayTime = lastDelay.getDelayTime();
            LOGGER.warn("Delay of {} is now attempted: {} times", (Object)DurationFormatUtils.formatDurationWords((long)lastDelayTime.toMillis(), (boolean)true, (boolean)true), (Object)lastDelay.getAttempts());
            return new DelaysAndMaxRetry(intendedMaxRetries, (List<Delay>)ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.limit(delayTimesList, (int)(delayTimesList.size() - 1)), (Iterable)ImmutableList.of((Object)new Delay(lastDelay.getAttempts() + extra, lastDelayTime)))));
        }
        throw new MessagingException("No delaytimes, cannot continue");
    }

    private static List<Delay> createDelayList(String delaysAsString) {
        if (delaysAsString == null) {
            return ImmutableList.of((Object)new Delay());
        }
        List delayStrings = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)delaysAsString);
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            for (String s : delayStrings) {
                builder.add((Object)Delay.from(s));
            }
            return builder.build();
        }
        catch (Exception e) {
            LOGGER.warn("Invalid delayTime setting: {}", (Object)delaysAsString);
            return builder.build();
        }
    }

    private static int computeTotalAttempts(List<Delay> delayList) {
        return delayList.stream().mapToInt(Delay::getAttempts).sum();
    }

    @VisibleForTesting
    DelaysAndMaxRetry(int maxRetries, List<Delay> delays) {
        this.maxRetries = maxRetries;
        this.delays = ImmutableList.copyOf(delays);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public ImmutableList<Duration> getExpandedDelays() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Delay delay : this.delays) {
            builder.addAll(delay.getExpendendDelays());
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (o instanceof DelaysAndMaxRetry) {
            DelaysAndMaxRetry that = (DelaysAndMaxRetry)o;
            return Objects.equal((Object)this.maxRetries, (Object)that.maxRetries) && Objects.equal(this.delays, that.delays);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.maxRetries, this.delays});
    }
}

