/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressesArrayToMailAddressListConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddressesArrayToMailAddressListConverter.class);

    public static List<MailAddress> getAddressesAsMailAddress(Address[] addresses) {
        if (addresses == null) {
            return ImmutableList.of();
        }
        return (List)Arrays.asList(addresses).stream().map(address -> AddressesArrayToMailAddressListConverter.toMailAddress(address)).flatMap(Optional::stream).collect(Guavate.toImmutableList());
    }

    private static Optional<MailAddress> toMailAddress(Address address) {
        try {
            return Optional.of(new MailAddress(address.toString()));
        }
        catch (AddressException e) {
            LOGGER.debug("Can't parse unsent address {}", (Object)address, (Object)e);
            return Optional.empty();
        }
    }
}

