/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.streams.Iterators;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import reactor.core.publisher.Mono;

public class RandomStoring
extends GenericMailet {
    private static final int MIN_NUMBER_OF_RECIPIENTS = 4;
    private static final int MAX_NUMBER_OF_RECIPIENTS = 8;
    private static final Duration CACHE_DURATION = Duration.ofMinutes(15L);
    private final Mono<List<ReroutingInfos>> reroutingInfos;
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;
    private final Supplier<Integer> randomRecipientsNumbers;

    @Inject
    public RandomStoring(UsersRepository usersRepository, MailboxManager mailboxManager) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
        this.randomRecipientsNumbers = () -> ThreadLocalRandom.current().nextInt(4, 9);
        this.reroutingInfos = Mono.fromCallable(this::retrieveReroutingInfos).cache(CACHE_DURATION);
    }

    public void service(Mail mail) throws MessagingException {
        Collection<ReroutingInfos> reroutingInfos = this.generateRandomMailboxes();
        Collection mailAddresses = (Collection)reroutingInfos.stream().map(Throwing.function(info -> info.getUser().asMailAddress())).collect(Guavate.toImmutableList());
        mail.setRecipients(mailAddresses);
        reroutingInfos.forEach(reroutingInfo -> mail.setAttribute(Attribute.convertToAttribute((String)("DeliveryPath_" + reroutingInfo.getUser().asString()), (Object)reroutingInfo.getMailbox())));
    }

    public String getMailetInfo() {
        return "Random Storing Mailet";
    }

    public void init() throws MessagingException {
    }

    private Collection<ReroutingInfos> generateRandomMailboxes() {
        List reroutingInfos = (List)this.reroutingInfos.block();
        return (Collection)ThreadLocalRandom.current().ints(0, reroutingInfos.size()).distinct().mapToObj(reroutingInfos::get).limit(this.randomRecipientsNumbers.get().intValue()).collect(Guavate.toImmutableSet());
    }

    private List<ReroutingInfos> retrieveReroutingInfos() throws UsersRepositoryException {
        return (List)Iterators.toStream((Iterator)this.usersRepository.list()).flatMap(this::buildReRoutingInfos).collect(Guavate.toImmutableList());
    }

    private Stream<ReroutingInfos> buildReRoutingInfos(Username username) {
        try {
            MailboxSession session = this.mailboxManager.createSystemSession(username);
            return this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).build(), MailboxManager.MailboxSearchFetchType.Minimal, session).toStream().map(metaData -> new ReroutingInfos(metaData.getPath().getName(), username));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ReroutingInfos {
        private final String mailbox;
        private final Username username;

        ReroutingInfos(String mailbox, Username username) {
            this.mailbox = mailbox;
            this.username = username;
        }

        public String getMailbox() {
            return this.mailbox;
        }

        public Username getUser() {
            return this.username;
        }

        public boolean equals(Object o) {
            if (o instanceof ReroutingInfos) {
                ReroutingInfos that = (ReroutingInfos)o;
                return Objects.equals(this.mailbox, that.mailbox) && Objects.equals(this.username, that.username);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.mailbox, this.username);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mailbox", (Object)this.mailbox).add("username", (Object)this.username).toString();
        }
    }
}

