/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.MessagingException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.transport.mailets.delivery.MailDispatcher;
import org.apache.james.transport.mailets.delivery.MailboxAppender;
import org.apache.james.transport.mailets.delivery.SimpleMailStore;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class LocalDelivery
extends GenericMailet {
    public static final String LOCAL_DELIVERED_MAILS_METRIC_NAME = "localDeliveredMails";
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;
    private final MetricFactory metricFactory;
    private MailDispatcher mailDispatcher;

    @Inject
    public LocalDelivery(UsersRepository usersRepository, @Named(value="mailboxmanager") MailboxManager mailboxManager, MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
    }

    public void service(Mail mail) throws MessagingException {
        this.mailDispatcher.dispatch(mail);
    }

    public String getMailetInfo() {
        return "Local Delivery Mailet";
    }

    public void init() throws MessagingException {
        this.mailDispatcher = MailDispatcher.builder().mailStore(SimpleMailStore.builder().mailboxAppender(new MailboxAppender(this.mailboxManager)).usersRepository(this.usersRepository).folder("INBOX").metric(this.metricFactory.generate(LOCAL_DELIVERED_MAILS_METRIC_NAME)).build()).consume(this.getInitParameter("consume", true)).mailetContext(this.getMailetContext()).build();
    }
}

