/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.linshare.client;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.james.core.MailAddress;
import org.apache.james.linshare.client.Document;

public class ShareRequest {
    private final List<Recipient> recipients;
    private final List<Document.DocumentId> documentIds;
    private final String message;

    public static RequireMessage builder() {
        return Builder::new;
    }

    private ShareRequest(List<Recipient> recipients, List<Document.DocumentId> documentIds, String message) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull(recipients);
        Preconditions.checkNotNull(documentIds);
        Preconditions.checkArgument((!recipients.isEmpty() ? 1 : 0) != 0, (Object)"recipients cannot be empty");
        Preconditions.checkArgument((!documentIds.isEmpty() ? 1 : 0) != 0, (Object)"documents cannot be empty");
        this.message = message;
        this.recipients = recipients;
        this.documentIds = documentIds;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public List<String> getDocuments() {
        return (List)this.documentIds.stream().map(Document.DocumentId::getId).map(UUID::toString).collect(Guavate.toImmutableList());
    }

    public final boolean equals(Object o) {
        if (o instanceof ShareRequest) {
            ShareRequest that = (ShareRequest)o;
            return Objects.equals(this.recipients, that.recipients) && Objects.equals(this.documentIds, that.documentIds) && Objects.equals(this.message, that.message);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.recipients, this.documentIds, this.message);
    }

    public static class Builder {
        private final ImmutableList.Builder<Recipient> recipientsBuilder;
        private final ImmutableList.Builder<Document.DocumentId> documentIdsBuilder;
        private final String message;

        Builder(String message) {
            this.message = message;
            this.recipientsBuilder = new ImmutableList.Builder();
            this.documentIdsBuilder = new ImmutableList.Builder();
        }

        public Builder addRecipient(MailAddress recipient) {
            this.recipientsBuilder.add((Object)new Recipient(recipient));
            return this;
        }

        public Builder addDocumentId(Document.DocumentId documentId) {
            this.documentIdsBuilder.add((Object)documentId);
            return this;
        }

        public ShareRequest build() {
            return new ShareRequest((List<Recipient>)this.recipientsBuilder.build(), (List<Document.DocumentId>)this.documentIdsBuilder.build(), this.message);
        }
    }

    @FunctionalInterface
    public static interface RequireMessage {
        public Builder message(String var1);
    }

    static class Recipient {
        private final MailAddress mail;

        @VisibleForTesting
        Recipient(MailAddress mail) {
            Preconditions.checkNotNull((Object)mail);
            Preconditions.checkArgument((!MailAddress.nullSender().equals((Object)mail) ? 1 : 0) != 0, (Object)"nullSender is not allowed");
            this.mail = mail;
        }

        public String getMail() {
            return this.mail.asString();
        }

        public final boolean equals(Object o) {
            if (o instanceof Recipient) {
                Recipient recipient = (Recipient)o;
                return Objects.equals(this.mail, recipient.mail);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.mail);
        }
    }
}

