/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import java.security.PublicKey;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.jwt.MissingOrInvalidKeyException;
import org.apache.james.jwt.PublicKeyReader;

public class PublicKeyProvider {
    private final JwtConfiguration jwtConfiguration;
    private final PublicKeyReader reader;

    public PublicKeyProvider(JwtConfiguration jwtConfiguration, PublicKeyReader reader) {
        this.jwtConfiguration = jwtConfiguration;
        this.reader = reader;
    }

    public PublicKey get() throws MissingOrInvalidKeyException {
        return this.reader.fromPEM(this.jwtConfiguration.getJwtPublicKeyPem()).orElseThrow(MissingOrInvalidKeyException::new);
    }
}

