/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.james.jmap.draft.json.ObjectMapperFactory;
import org.apache.james.jmap.draft.methods.GetFilterMethod;
import org.apache.james.jmap.draft.methods.GetMailboxesMethod;
import org.apache.james.jmap.draft.methods.GetMessageListMethod;
import org.apache.james.jmap.draft.methods.GetMessagesMethod;
import org.apache.james.jmap.draft.methods.GetVacationResponseMethod;
import org.apache.james.jmap.draft.methods.JmapRequestParser;
import org.apache.james.jmap.draft.methods.JmapRequestParserImpl;
import org.apache.james.jmap.draft.methods.JmapResponseWriter;
import org.apache.james.jmap.draft.methods.JmapResponseWriterImpl;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.methods.SendMDNProcessor;
import org.apache.james.jmap.draft.methods.SetFilterMethod;
import org.apache.james.jmap.draft.methods.SetMailboxesCreationProcessor;
import org.apache.james.jmap.draft.methods.SetMailboxesDestructionProcessor;
import org.apache.james.jmap.draft.methods.SetMailboxesMethod;
import org.apache.james.jmap.draft.methods.SetMailboxesProcessor;
import org.apache.james.jmap.draft.methods.SetMailboxesUpdateProcessor;
import org.apache.james.jmap.draft.methods.SetMessagesCreationProcessor;
import org.apache.james.jmap.draft.methods.SetMessagesDestructionProcessor;
import org.apache.james.jmap.draft.methods.SetMessagesMethod;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.methods.SetMessagesUpdateProcessor;
import org.apache.james.jmap.draft.methods.SetVacationResponseMethod;
import org.apache.james.jmap.http.AccessTokenAuthenticationStrategy;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.QueryParameterAccessTokenAuthenticationStrategy;
import org.apache.james.jmap.jwt.JWTAuthenticationStrategy;
import org.apache.james.metrics.api.MetricFactory;

public class DraftMethodsModule
extends AbstractModule {
    protected void configure() {
        this.bind(JmapRequestParserImpl.class).in(Scopes.SINGLETON);
        this.bind(JmapResponseWriterImpl.class).in(Scopes.SINGLETON);
        this.bind(ObjectMapperFactory.class).in(Scopes.SINGLETON);
        this.bind(JmapRequestParser.class).to(JmapRequestParserImpl.class);
        this.bind(JmapResponseWriter.class).to(JmapResponseWriterImpl.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"maximumLimit")).to(256L);
        Multibinder methods = Multibinder.newSetBinder((Binder)this.binder(), Method.class);
        methods.addBinding().to(GetMailboxesMethod.class);
        methods.addBinding().to(GetMessageListMethod.class);
        methods.addBinding().to(GetMessagesMethod.class);
        methods.addBinding().to(SetMessagesMethod.class);
        methods.addBinding().to(SetMailboxesMethod.class);
        methods.addBinding().to(GetVacationResponseMethod.class);
        methods.addBinding().to(SetVacationResponseMethod.class);
        methods.addBinding().to(GetFilterMethod.class);
        methods.addBinding().to(SetFilterMethod.class);
        Multibinder setMailboxesProcessor = Multibinder.newSetBinder((Binder)this.binder(), SetMailboxesProcessor.class);
        setMailboxesProcessor.addBinding().to(SetMailboxesCreationProcessor.class);
        setMailboxesProcessor.addBinding().to(SetMailboxesUpdateProcessor.class);
        setMailboxesProcessor.addBinding().to(SetMailboxesDestructionProcessor.class);
        Multibinder setMessagesProcessors = Multibinder.newSetBinder((Binder)this.binder(), SetMessagesProcessor.class);
        setMessagesProcessors.addBinding().to(SetMessagesUpdateProcessor.class);
        setMessagesProcessors.addBinding().to(SetMessagesCreationProcessor.class);
        setMessagesProcessors.addBinding().to(SetMessagesDestructionProcessor.class);
        setMessagesProcessors.addBinding().to(SendMDNProcessor.class);
    }

    @Provides
    @Named(value="DRAFT")
    Authenticator provideAuthenticator(MetricFactory metricFactory, AccessTokenAuthenticationStrategy accessTokenAuthenticationStrategy, JWTAuthenticationStrategy jwtAuthenticationStrategy, QueryParameterAccessTokenAuthenticationStrategy queryParameterAuthenticationStrategy) {
        return Authenticator.of((MetricFactory)metricFactory, (AuthenticationStrategy[])new AuthenticationStrategy[]{jwtAuthenticationStrategy, accessTokenAuthenticationStrategy, queryParameterAuthenticationStrategy});
    }
}

