/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.cassandra.CassandraBlobStoreDAO;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreDAO;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTO;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTOModule;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.BlobStoreConfigurationValidationStartUpCheck;
import org.apache.james.modules.blobstore.validation.EventsourcingStorageStrategy;
import org.apache.james.modules.blobstore.validation.StorageStrategyModule;
import org.apache.james.modules.mailbox.CassandraBlobStoreDependenciesModule;
import org.apache.james.modules.mailbox.CassandraBucketModule;
import org.apache.james.modules.objectstorage.DefaultBucketModule;
import org.apache.james.modules.objectstorage.S3BlobStoreModule;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore;
import org.apache.james.server.blob.deduplication.PassThroughBlobStore;
import org.apache.james.server.blob.deduplication.StorageStrategy;

public class BlobStoreModulesChooser {
    @VisibleForTesting
    public static List<Module> chooseModules(BlobStoreConfiguration choosingConfiguration) {
        return ImmutableList.builder().add((Object)BlobStoreModulesChooser.chooseBlobStoreDAOModule(choosingConfiguration.getImplementation())).add((Object)BlobStoreModulesChooser.chooseStoragePolicyModule(choosingConfiguration.storageStrategy())).add((Object)new StoragePolicyConfigurationSanityEnforcementModule(choosingConfiguration)).build();
    }

    public static Module chooseBlobStoreDAOModule(BlobStoreConfiguration.BlobStoreImplName implementation) {
        switch (implementation) {
            case CASSANDRA: {
                return new CassandraBlobStoreDAODeclarationModule();
            }
            case S3: {
                return new ObjectStorageBlobStoreDAODeclarationModule();
            }
        }
        throw new RuntimeException("Unsupported blobStore implementation " + implementation);
    }

    private static Module chooseStoragePolicyModule(StorageStrategy storageStrategy) {
        switch (storageStrategy) {
            case DEDUPLICATION: {
                return binder -> binder.bind(BlobStore.class).annotatedWith((Annotation)Names.named((String)"blobStoreBackend")).to(DeDuplicationBlobStore.class);
            }
            case PASSTHROUGH: {
                return binder -> binder.bind(BlobStore.class).annotatedWith((Annotation)Names.named((String)"blobStoreBackend")).to(PassThroughBlobStore.class);
            }
        }
        throw new RuntimeException("Unknown storage strategy " + storageStrategy.name());
    }

    static class StoragePolicyConfigurationSanityEnforcementModule
    extends AbstractModule {
        private BlobStoreConfiguration choosingConfiguration;

        StoragePolicyConfigurationSanityEnforcementModule(BlobStoreConfiguration choosingConfiguration) {
            this.choosingConfiguration = choosingConfiguration;
        }

        protected void configure() {
            Multibinder eventDTOModuleBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<EventDTOModule<? extends Event, ? extends EventDTO>>(){});
            eventDTOModuleBinder.addBinding().toInstance(StorageStrategyModule.STORAGE_STRATEGY);
            this.bind(BlobStoreConfiguration.class).toInstance((Object)this.choosingConfiguration);
            this.bind(EventsourcingStorageStrategy.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)this.binder(), StartUpCheck.class).addBinding().to(BlobStoreConfigurationValidationStartUpCheck.class);
        }
    }

    static class ObjectStorageBlobStoreDAODeclarationModule
    extends AbstractModule {
        ObjectStorageBlobStoreDAODeclarationModule() {
        }

        protected void configure() {
            this.install((Module)new S3BlobStoreModule());
            this.install((Module)new DefaultBucketModule());
            this.bind(BlobStoreDAO.class).to(S3BlobStoreDAO.class);
        }
    }

    static class CassandraBlobStoreDAODeclarationModule
    extends AbstractModule {
        CassandraBlobStoreDAODeclarationModule() {
        }

        protected void configure() {
            this.install((Module)new CassandraBlobStoreDependenciesModule());
            this.install((Module)new CassandraBucketModule());
            this.bind(BlobStoreDAO.class).to(CassandraBlobStoreDAO.class);
        }
    }
}

