/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.vavr.control.Try;
import java.io.FileNotFoundException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.modules.mailbox.ConfigurationComponent;
import org.apache.james.server.blob.deduplication.StorageStrategy;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreConfiguration.class);
    static final String BLOBSTORE_IMPLEMENTATION_PROPERTY = "implementation";
    static final String CACHE_ENABLE_PROPERTY = "cache.enable";
    static final boolean CACHE_ENABLED = true;
    static final String DEDUPLICATION_ENABLE_PROPERTY = "deduplication.enable";
    private final BlobStoreImplName implementation;
    private final boolean cacheEnabled;
    private final StorageStrategy storageStrategy;

    public static RequireImplementation builder() {
        return implementation -> enableCache -> storageStrategy -> new BlobStoreConfiguration(implementation, enableCache, storageStrategy);
    }

    public static BlobStoreConfiguration parse(Configuration configuration) throws ConfigurationException {
        PropertiesProvider propertiesProvider = new PropertiesProvider((FileSystem)new FileSystemImpl(configuration.directories()), configuration.configurationPath());
        return BlobStoreConfiguration.parse(propertiesProvider);
    }

    public static BlobStoreConfiguration parse(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            org.apache.commons.configuration2.Configuration configuration = propertiesProvider.getConfigurations(ConfigurationComponent.NAMES);
            return BlobStoreConfiguration.from(configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find blob configuration file, using cassandra blobstore as the default");
            return BlobStoreConfiguration.builder().cassandra().disableCache().passthrough();
        }
    }

    static BlobStoreConfiguration from(org.apache.commons.configuration2.Configuration configuration) {
        BlobStoreImplName blobStoreImplName = Optional.ofNullable(configuration.getString(BLOBSTORE_IMPLEMENTATION_PROPERTY)).filter(StringUtils::isNotBlank).map(StringUtils::trim).map(BlobStoreImplName::from).orElseThrow(() -> new IllegalStateException(String.format("%s property is missing please use one of supported values in: %s", BLOBSTORE_IMPLEMENTATION_PROPERTY, BlobStoreImplName.supportedImplNames())));
        boolean cacheEnabled = configuration.getBoolean(CACHE_ENABLE_PROPERTY, false);
        boolean deduplicationEnabled = (Boolean)Try.ofCallable(() -> configuration.getBoolean(DEDUPLICATION_ENABLE_PROPERTY)).getOrElseThrow(() -> new IllegalStateException("deduplication.enable property is missing please use one of the supported values in: true, false\nIf you choose to enable deduplication, the mails with the same content will be stored only once.\nWarning: Once this feature is enabled, there is no turning back as turning it off will lead to the deletion of all\nthe mails sharing the same content once one is deleted.\nUpgrade note: If you are upgrading from James 3.5 or older, the deduplication was enabled."));
        if (deduplicationEnabled) {
            return new BlobStoreConfiguration(blobStoreImplName, cacheEnabled, StorageStrategy.DEDUPLICATION);
        }
        return new BlobStoreConfiguration(blobStoreImplName, cacheEnabled, StorageStrategy.PASSTHROUGH);
    }

    @VisibleForTesting
    public static RequireStoringStrategy cassandra() {
        return BlobStoreConfiguration.builder().cassandra().disableCache();
    }

    public static RequireCache s3() {
        return BlobStoreConfiguration.builder().s3();
    }

    BlobStoreConfiguration(BlobStoreImplName implementation, boolean cacheEnabled, StorageStrategy storageStrategy) {
        this.implementation = implementation;
        this.cacheEnabled = cacheEnabled;
        this.storageStrategy = storageStrategy;
    }

    public boolean cacheEnabled() {
        return this.cacheEnabled;
    }

    public StorageStrategy storageStrategy() {
        return this.storageStrategy;
    }

    BlobStoreImplName getImplementation() {
        return this.implementation;
    }

    public final boolean equals(Object o) {
        if (o instanceof BlobStoreConfiguration) {
            BlobStoreConfiguration that = (BlobStoreConfiguration)o;
            return Objects.equals((Object)this.implementation, (Object)that.implementation) && Objects.equals(this.cacheEnabled, that.cacheEnabled) && Objects.equals(this.storageStrategy, that.storageStrategy);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.implementation, this.cacheEnabled, this.storageStrategy});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(BLOBSTORE_IMPLEMENTATION_PROPERTY, (Object)this.implementation).add("cacheEnabled", this.cacheEnabled).add("storageStrategy", (Object)this.storageStrategy.name()).toString();
    }

    public static enum BlobStoreImplName {
        CASSANDRA("cassandra"),
        S3("s3");

        private final String name;

        static String supportedImplNames() {
            return Stream.of(BlobStoreImplName.values()).map(BlobStoreImplName::getName).collect(Collectors.joining(", "));
        }

        static BlobStoreImplName from(String name) {
            return Stream.of(BlobStoreImplName.values()).filter(blobName -> blobName.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a valid name of BlobStores, please use one of supported values in: %s", name, BlobStoreImplName.supportedImplNames())));
        }

        private BlobStoreImplName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    @FunctionalInterface
    public static interface RequireStoringStrategy {
        public BlobStoreConfiguration strategy(StorageStrategy var1);

        default public BlobStoreConfiguration passthrough() {
            return this.strategy(StorageStrategy.PASSTHROUGH);
        }

        default public BlobStoreConfiguration deduplication() {
            return this.strategy(StorageStrategy.DEDUPLICATION);
        }
    }

    @FunctionalInterface
    public static interface RequireCache {
        public RequireStoringStrategy enableCache(boolean var1);

        default public RequireStoringStrategy enableCache() {
            return this.enableCache(true);
        }

        default public RequireStoringStrategy disableCache() {
            return this.enableCache(false);
        }
    }

    @FunctionalInterface
    public static interface RequireImplementation {
        public RequireCache implementation(BlobStoreImplName var1);

        default public RequireCache cassandra() {
            return this.implementation(BlobStoreImplName.CASSANDRA);
        }

        default public RequireCache s3() {
            return this.implementation(BlobStoreImplName.S3);
        }
    }
}

