/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableSet;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.james.webadmin.PublicRoutes;
import spark.Request;
import spark.Response;
import spark.Service;

public class MetricsRoutes
implements PublicRoutes {
    public static final String BASE = "/metrics";
    private final CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;

    @Inject
    public MetricsRoutes(MetricRegistry registry) {
        new DropwizardExports(registry).register(this.collectorRegistry);
    }

    public String getBasePath() {
        return BASE;
    }

    public void define(Service service) {
        service.get(BASE, this::getMetrics);
    }

    public Response getMetrics(Request request, Response response) throws IOException {
        Set<String> params = this.parse(request.raw());
        HttpServletResponse rawResponse = response.raw();
        rawResponse.setStatus(200);
        rawResponse.setContentType("text/plain; version=0.0.4; charset=utf-8");
        try (BufferedWriter writer = new BufferedWriter(rawResponse.getWriter());){
            TextFormat.write004((Writer)writer, (Enumeration)this.collectorRegistry.filteredMetricFamilySamples(params));
            ((Writer)writer).flush();
        }
        return response;
    }

    private Set<String> parse(HttpServletRequest req) {
        String[] includedParam = req.getParameterValues("name[]");
        return (Set)Optional.ofNullable(includedParam).map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
    }
}

