/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.processor.ThreadsProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;

public class ThreadsReifier
extends ProcessorReifier<ThreadsDefinition> {
    public ThreadsReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ThreadsDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        String name = ((ThreadsDefinition)this.definition).getThreadName() != null ? this.parseString(((ThreadsDefinition)this.definition).getThreadName()) : "Threads";
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)this.definition, true);
        ExecutorService threadPool = this.getConfiguredExecutorService(name, (ExecutorServiceAwareDefinition)this.definition, false);
        ThreadPoolRejectedPolicy policy = this.resolveRejectedPolicy();
        if (policy == null) {
            policy = this.parseBoolean(((ThreadsDefinition)this.definition).getCallerRunsWhenRejected(), true) ? ThreadPoolRejectedPolicy.CallerRuns : ThreadPoolRejectedPolicy.Abort;
        }
        if (threadPool == null) {
            ThreadPoolProfile profile = new ThreadPoolProfile(name);
            profile.setPoolSize(((ThreadsDefinition)this.definition).getPoolSize() != null ? this.parseInt(((ThreadsDefinition)this.definition).getPoolSize()) : null);
            profile.setMaxPoolSize(((ThreadsDefinition)this.definition).getMaxPoolSize() != null ? this.parseInt(((ThreadsDefinition)this.definition).getMaxPoolSize()) : null);
            profile.setKeepAliveTime(((ThreadsDefinition)this.definition).getKeepAliveTime() != null ? this.parseDuration(((ThreadsDefinition)this.definition).getKeepAliveTime()) : null);
            profile.setTimeUnit(((ThreadsDefinition)this.definition).getTimeUnit() != null ? this.parse(TimeUnit.class, ((ThreadsDefinition)this.definition).getTimeUnit()) : null);
            profile.setMaxQueueSize(((ThreadsDefinition)this.definition).getMaxQueueSize() != null ? this.parseInt(((ThreadsDefinition)this.definition).getMaxQueueSize()) : null);
            profile.setRejectedPolicy(policy);
            profile.setAllowCoreThreadTimeOut(((ThreadsDefinition)this.definition).getAllowCoreThreadTimeOut() != null ? Boolean.valueOf(this.parseBoolean(((ThreadsDefinition)this.definition).getAllowCoreThreadTimeOut(), false)) : null);
            ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
            threadPool = manager.newThreadPool((Object)this.definition, name, profile);
            shutdownThreadPool = true;
        } else {
            if (((ThreadsDefinition)this.definition).getThreadName() != null && !((ThreadsDefinition)this.definition).getThreadName().equals("Threads")) {
                throw new IllegalArgumentException("ThreadName and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getPoolSize() != null) {
                throw new IllegalArgumentException("PoolSize and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getMaxPoolSize() != null) {
                throw new IllegalArgumentException("MaxPoolSize and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getKeepAliveTime() != null) {
                throw new IllegalArgumentException("KeepAliveTime and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getTimeUnit() != null) {
                throw new IllegalArgumentException("TimeUnit and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getMaxQueueSize() != null) {
                throw new IllegalArgumentException("MaxQueueSize and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getRejectedPolicy() != null) {
                throw new IllegalArgumentException("RejectedPolicy and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getAllowCoreThreadTimeOut() != null) {
                throw new IllegalArgumentException("AllowCoreThreadTimeOut and executorServiceRef options cannot be used together.");
            }
        }
        return new ThreadsProcessor(this.camelContext, threadPool, shutdownThreadPool, policy);
    }

    protected ThreadPoolRejectedPolicy resolveRejectedPolicy() {
        ThreadPoolProfile threadPoolProfile;
        if (((ThreadsDefinition)this.definition).getExecutorServiceRef() != null && ((ThreadsDefinition)this.definition).getRejectedPolicy() == null && (threadPoolProfile = this.camelContext.getExecutorServiceManager().getThreadPoolProfile(this.parseString(((ThreadsDefinition)this.definition).getExecutorServiceRef()))) != null) {
            return threadPoolProfile.getRejectedPolicy();
        }
        return this.parse(ThreadPoolRejectedPolicy.class, ((ThreadsDefinition)this.definition).getRejectedPolicy());
    }
}

