/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public abstract class EndpointUriFactorySupport
implements CamelContextAware,
EndpointUriFactory {
    protected CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected String buildPathParameter(String syntax, String uri, String name, Object defaultValue, boolean required, Map<String, Object> parameters) {
        Object obj = parameters.remove(name);
        if (ObjectHelper.isEmpty((Object)obj) && defaultValue != null && required) {
            obj = this.camelContext.getTypeConverter().convertTo(String.class, defaultValue);
        }
        if (ObjectHelper.isEmpty((Object)obj) && required) {
            throw new IllegalArgumentException("Option " + name + " is required when creating endpoint uri with syntax " + syntax);
        }
        if (ObjectHelper.isNotEmpty((Object)obj)) {
            String str = (String)this.camelContext.getTypeConverter().convertTo(String.class, obj);
            uri = uri.replace(name, str);
        } else {
            char ch;
            int pos = uri.indexOf(name);
            if (pos != -1 && !Character.isLetterOrDigit(ch = (uri = uri.replaceFirst(name, "")).charAt(--pos))) {
                uri = uri.substring(0, pos) + uri.substring(pos + 1);
            }
        }
        return uri;
    }

    protected String buildQueryParameters(String uri, Map<String, Object> parameters, boolean encode) throws URISyntaxException {
        TreeMap<String, Object> map = new TreeMap<String, Object>(parameters);
        for (String secretParameter : this.secretPropertyNames()) {
            String answer;
            Object val = map.get(secretParameter);
            if (!(val instanceof String) || (answer = (String)val).startsWith("#") || answer.startsWith("RAW(")) continue;
            map.put(secretParameter, "RAW(" + val + ")");
        }
        String query = URISupport.createQueryString(map, (boolean)encode);
        if (ObjectHelper.isNotEmpty((Object)query)) {
            boolean questionMark = uri.indexOf(63) != -1;
            uri = questionMark ? uri + "&" + query : uri + "?" + query;
        }
        return uri;
    }
}

