/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterView;
import org.apache.camel.cluster.CamelPreemptiveClusterService;
import org.apache.camel.cluster.CamelPreemptiveClusterView;
import org.apache.camel.spi.HasId;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebalancingCamelClusterService
implements CamelPreemptiveClusterService {
    private static final Logger LOG = LoggerFactory.getLogger(RebalancingCamelClusterService.class);
    protected ScheduledExecutorService serializedExecutor;
    protected CamelPreemptiveClusterService delegate;
    protected CamelContext camelContext;
    protected long periodMillis;

    public RebalancingCamelClusterService(CamelPreemptiveClusterService delegate, long periodMillis) {
        this.delegate = (CamelPreemptiveClusterService)ObjectHelper.notNull((Object)delegate, (String)"delegate");
        this.periodMillis = periodMillis;
    }

    public RebalancingCamelClusterService(CamelContext camelContext, CamelPreemptiveClusterService delegate, long periodMillis) {
        this.camelContext = (CamelContext)ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        this.delegate = (CamelPreemptiveClusterService)ObjectHelper.notNull((Object)delegate, (String)"delegate");
        this.periodMillis = periodMillis;
    }

    public void start() {
        this.delegate.start();
        if (this.serializedExecutor == null) {
            this.serializedExecutor = this.getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "RebalancingClusterService");
            this.serializedExecutor.execute(this::reconcile);
        }
    }

    public void stop() {
        if (this.serializedExecutor != null) {
            this.serializedExecutor.shutdownNow();
        }
        this.serializedExecutor = null;
        this.delegate.stop();
    }

    public CamelPreemptiveClusterService getDelegate() {
        return this.delegate;
    }

    public long getPeriodMillis() {
        return this.periodMillis;
    }

    public void setDelegate(CamelPreemptiveClusterService delegate) {
        this.delegate = delegate;
    }

    protected void reconcile() {
        int i;
        int threshold;
        Integer n = this.members();
        List<String> partitions = this.partitionList();
        int k = partitions.size();
        if (n == null || n == 0 || k == 0) {
            this.rescheduleAfterDelay();
            return;
        }
        for (threshold = 0; threshold <= k; threshold += n.intValue()) {
        }
        int quota = (threshold -= n.intValue()) / n;
        ArrayList<String> main = new ArrayList<String>();
        ArrayList<String> remaining = new ArrayList<String>();
        for (i = 0; i < threshold; ++i) {
            main.add(partitions.get(i));
        }
        for (i = threshold; i < partitions.size(); ++i) {
            remaining.add(partitions.get(i));
        }
        this.rebalanceGroup(main, quota);
        this.rebalanceGroup(remaining, 1);
        this.rescheduleAfterDelay();
    }

    protected void rebalanceGroup(List<String> partitions, int quota) {
        List<String> owned = this.owned(partitions);
        if (owned == null) {
            return;
        }
        if (owned.size() < quota) {
            for (String partition : partitions) {
                this.setDisabled(partition, false);
            }
        } else if (owned.size() > quota) {
            for (int i = 0; i < owned.size() - quota; ++i) {
                this.setDisabled(owned.get(i), true);
            }
        } else {
            HashSet<String> ownedSet = new HashSet<String>(owned);
            for (String partition : partitions) {
                if (ownedSet.contains(partition)) continue;
                this.setDisabled(partition, true);
            }
        }
    }

    protected void setDisabled(String partition, boolean disabled) {
        try {
            LOG.debug("Setting partition {} to disabled={}...", (Object)partition, (Object)disabled);
            CamelPreemptiveClusterView view = this.delegate.getView(partition);
            if (view.isDisabled() != disabled) {
                view.setDisabled(disabled);
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not get view " + partition, (Throwable)ex);
        }
    }

    protected List<String> owned(List<String> partitions) {
        ArrayList<String> owned = new ArrayList<String>(partitions.size());
        for (String partition : partitions) {
            try {
                CamelPreemptiveClusterView view = this.delegate.getView(partition);
                if (view.isDisabled() || !view.getLocalMember().isLeader()) continue;
                owned.add(partition);
            }
            catch (Exception ex) {
                LOG.warn("Could not get view " + partition, (Throwable)ex);
                return null;
            }
        }
        return owned;
    }

    protected List<String> partitionList() {
        ArrayList<String> partitions = new ArrayList<String>(this.getNamespaces());
        Collections.sort(partitions);
        return partitions;
    }

    protected Integer members() {
        Set members = null;
        for (String group : this.getNamespaces()) {
            try {
                CamelPreemptiveClusterView view = this.delegate.getView(group);
                Set viewMembers = view.getMembers().stream().map(HasId::getId).collect(Collectors.toSet());
                if (members != null && !members.equals(viewMembers)) {
                    LOG.debug("View members don't match: {} vs {}", members, viewMembers);
                    return null;
                }
                members = viewMembers;
            }
            catch (Exception ex) {
                LOG.warn("Could not get view " + group, (Throwable)ex);
                return null;
            }
        }
        return members != null ? members.size() : 0;
    }

    private void rescheduleAfterDelay() {
        this.serializedExecutor.schedule(this::reconcile, this.periodMillis, TimeUnit.MILLISECONDS);
    }

    public CamelPreemptiveClusterView getView(String namespace) throws Exception {
        return this.delegate.getView(namespace);
    }

    public void releaseView(CamelClusterView view) throws Exception {
        this.delegate.releaseView(view);
    }

    public Collection<String> getNamespaces() {
        return this.delegate.getNamespaces();
    }

    public void startView(String namespace) throws Exception {
        this.delegate.startView(namespace);
    }

    public void stopView(String namespace) throws Exception {
        this.delegate.stopView(namespace);
    }

    public boolean isLeader(String namespace) {
        return this.delegate.isLeader(namespace);
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.delegate.setCamelContext(camelContext);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setId(String id) {
        this.delegate.setId(id);
    }

    public String getId() {
        return this.delegate.getId();
    }
}

