/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.elasticsearch.v7.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRatio;
import org.apache.james.quota.search.elasticsearch.v7.json.QuotaRatioAsJson;

public class QuotaRatioToElasticSearchJson {
    private final ObjectMapper mapper = new ObjectMapper();

    @Inject
    public QuotaRatioToElasticSearchJson() {
        this.mapper.registerModule((Module)new Jdk8Module());
    }

    public String convertToJson(MailboxEvents.QuotaUsageUpdatedEvent event) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)QuotaRatioAsJson.builder().user(event.getUsername().asString()).domain(event.getQuotaRoot().getDomain().map(Domain::asString)).quotaRatio(QuotaRatio.from((Quota)event.getSizeQuota(), (Quota)event.getCountQuota())).build());
    }
}

