/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.cassandra;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.Event$;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.EventStoreFailedException;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.cassandra.EventStoreDao;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000514AAB\u0004\u0001)!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u00032\u0001\u0011\u0005#\u0007C\u0003T\u0001\u0011%A\u000bC\u0003b\u0001\u0011\u0005#MA\nDCN\u001c\u0018M\u001c3sC\u00163XM\u001c;Ti>\u0014XM\u0003\u0002\t\u0013\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u0015-\t!\"\u001a<f]R\u001cHo\u001c:f\u0015\taQ\"A\u0007fm\u0016tGo]8ve\u000eLgn\u001a\u0006\u0003\u001d=\tQA[1nKNT!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u000f\u000e\u0003%I!AH\u0005\u0003\u0015\u00153XM\u001c;Ti>\u0014X-A\u0007fm\u0016tGo\u0015;pe\u0016$\u0015m\u001c\t\u0003C\tj\u0011aB\u0005\u0003G\u001d\u0011Q\"\u0012<f]R\u001cFo\u001c:f\t\u0006|\u0017A\u0002\u001fj]&$h\b\u0006\u0002'OA\u0011\u0011\u0005\u0001\u0005\u0006?\t\u0001\r\u0001\t\u0015\u0003\u0005%\u0002\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\r%t'.Z2u\u0015\u0005q\u0013!\u00026bm\u0006D\u0018B\u0001\u0019,\u0005\u0019IeN[3di\u0006I\u0011\r\u001d9f]\u0012\fE\u000e\u001c\u000b\u0003g\u0005\u00032\u0001N\u001c:\u001b\u0005)$B\u0001\u001c\u0012\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c\u0018B\u0001\u001d6\u0005%\u0001VO\u00197jg\",'\u000f\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005!A.\u00198h\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\tY{\u0017\u000e\u001a\u0005\u0006\u0005\u000e\u0001\raQ\u0001\u0007KZ,g\u000e^:\u0011\u0007\u0011cuJ\u0004\u0002F\u0015:\u0011a)S\u0007\u0002\u000f*\u0011\u0001jE\u0001\u0007yI|w\u000e\u001e \n\u0003aI!aS\f\u0002\u000fA\f7m[1hK&\u0011QJ\u0014\u0002\t\u0013R,'/\u00192mK*\u00111j\u0006\t\u0003!Fk\u0011aC\u0005\u0003%.\u0011Q!\u0012<f]R\f1\u0002Z8BaB,g\u000eZ!mYR\u0011Q\u000b\u0019\t\u0004-zKT\"A,\u000b\u0005aK\u0016!\u00039vE2L7\u000f[3s\u0015\tA\"L\u0003\u0002\\9\u0006!1m\u001c:f\u0015\u0005i\u0016a\u0002:fC\u000e$xN]\u0005\u0003?^\u0013QaU'p]>DQA\u0011\u0003A\u0002\r\u000bAcZ3u\u000bZ,g\u000e^:PM\u0006;wM]3hCR,GCA2h!\r1f\f\u001a\t\u00039\u0015L!AZ\u0005\u0003\u000f!K7\u000f^8ss\")\u0001.\u0002a\u0001S\u0006Y\u0011mZ4sK\u001e\fG/Z%e!\t\u0001&.\u0003\u0002l\u0017\tY\u0011iZ4sK\u001e\fG/Z%e\u0001")
public class CassandraEventStore
implements EventStore {
    private final EventStoreDao eventStoreDao;

    public Publisher<Void> append(Event event) {
        return EventStore.append$((EventStore)this, (Event)event);
    }

    public Publisher<Void> appendAll(Seq<Event> events) {
        return EventStore.appendAll$((EventStore)this, events);
    }

    public Publisher<Void> appendAll(Event ... events) {
        return EventStore.appendAll$((EventStore)this, (Event[])events);
    }

    public Publisher<Void> appendAll(Iterable<Event> events) {
        return events.nonEmpty() ? this.doAppendAll(events) : SMono$.MODULE$.empty();
    }

    private SMono<Void> doAppendAll(Iterable<Event> events) {
        Preconditions.checkArgument((boolean)Event$.MODULE$.belongsToSameAggregate(events));
        return this.eventStoreDao.appendAll(events).filter((Function1 & Serializable)success -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)success))).single().onErrorMap((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof NoSuchElementException ? new EventStoreFailedException("Concurrent update to the EventStore detected") : A1;
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchElementException ? true : true;
                return bl;
            }
        }).then(SMono$.MODULE$.empty());
    }

    public SMono<History> getEventsOfAggregate(AggregateId aggregateId) {
        return this.eventStoreDao.getEventsOfAggregate(aggregateId);
    }

    @Inject
    public CassandraEventStore(EventStoreDao eventStoreDao) {
        this.eventStoreDao = eventStoreDao;
        EventStore.$init$((EventStore)this);
    }
}

