/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.jwt;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;

public class JWTAuthenticationStrategy
implements AuthenticationStrategy {
    @VisibleForTesting
    public static final String AUTHORIZATION_HEADER_PREFIX = "Bearer ";
    private final JwtTokenVerifier tokenManager;
    private final MailboxManager mailboxManager;
    private final UsersRepository usersRepository;

    @Inject
    @VisibleForTesting
    public JWTAuthenticationStrategy(@Named(value="jmap") JwtTokenVerifier tokenManager, MailboxManager mailboxManager, UsersRepository usersRepository) {
        this.tokenManager = tokenManager;
        this.mailboxManager = mailboxManager;
        this.usersRepository = usersRepository;
    }

    @Override
    public Mono<MailboxSession> createMailboxSession(HttpServerRequest httpRequest) {
        return Mono.fromCallable(() -> this.authHeaders(httpRequest)).filter(header -> header.startsWith(AUTHORIZATION_HEADER_PREFIX)).map(header -> header.substring(AUTHORIZATION_HEADER_PREFIX.length())).map(userJWTToken -> {
            if (!this.tokenManager.verify(userJWTToken)) {
                throw new UnauthorizedException("Failed Jwt verification");
            }
            Username username = Username.of((String)this.tokenManager.extractLogin(userJWTToken));
            try {
                this.usersRepository.assertValid(username);
            }
            catch (UsersRepositoryException e) {
                throw new UnauthorizedException("Invalid username", e);
            }
            return username;
        }).map(arg_0 -> ((MailboxManager)this.mailboxManager).createSystemSession(arg_0));
    }
}

