/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.distributed;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.server.task.json.JsonTaskSerializer;
import org.apache.james.task.SerialTaskManagerWorker;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.eventsourcing.WorkQueueSupplier;
import org.apache.james.task.eventsourcing.WorkerStatusListener;
import org.apache.james.task.eventsourcing.distributed.CancelRequestQueueName;
import org.apache.james.task.eventsourcing.distributed.RabbitMQWorkQueue;
import org.apache.james.task.eventsourcing.distributed.RabbitMQWorkQueueConfiguration;
import reactor.rabbitmq.Sender;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001\u0002\t\u0012\u0001yA\u0001\"\u000b\u0001\u0003\u0006\u0004%IA\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005W!AA\u0007\u0001BC\u0002\u0013%Q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u00037\u0011!q\u0004A!b\u0001\n\u0013y\u0004\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011)\u0003!Q1A\u0005\n-C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t#\u0002\u0011)\u0019!C\u0005%\"Aa\u000b\u0001B\u0001B\u0003%1\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0004i\u0001\t\u0007I\u0011A5\t\rI\u0004\u0001\u0015!\u0003k\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u0015\u0019\b\u0001\"\u0001\u0000\u0005e\u0011\u0016M\u00192ji6\u000bvk\u001c:l#V,W/Z*vaBd\u0017.\u001a:\u000b\u0005I\u0019\u0012a\u00033jgR\u0014\u0018NY;uK\u0012T!\u0001F\u000b\u0002\u001b\u00154XM\u001c;t_V\u00148-\u001b8h\u0015\t1r#\u0001\u0003uCN\\'B\u0001\r\u001a\u0003\u0015Q\u0017-\\3t\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0014\u0013\tA3CA\tX_J\\\u0017+^3vKN+\b\u000f\u001d7jKJ\faa]3oI\u0016\u0014X#A\u0016\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u0003:bE\nLG/\\9\u000b\u0003A\nqA]3bGR|'/\u0003\u00023[\t11+\u001a8eKJ\fqa]3oI\u0016\u0014\b%\u0001\tsK\u000e,\u0017N^3s!J|g/\u001b3feV\ta\u0007\u0005\u00028w5\t\u0001H\u0003\u0002/s)\u0011!hF\u0001\tE\u0006\u001c7.\u001a8eg&\u0011A\b\u000f\u0002\u0011%\u0016\u001cW-\u001b<feB\u0013xN^5eKJ\f\u0011C]3dK&4XM\u001d)s_ZLG-\u001a:!\u0003IQ7o\u001c8UCN\\7+\u001a:jC2L'0\u001a:\u0016\u0003\u0001\u0003\"!Q$\u000e\u0003\tS!a\u0011#\u0002\t)\u001cxN\u001c\u0006\u0003-\u0015S!AR\f\u0002\rM,'O^3s\u0013\tA%I\u0001\nKg>tG+Y:l'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018a\u00056t_:$\u0016m]6TKJL\u0017\r\\5{KJ\u0004\u0013!E2b]\u000e,GNU3rk\u0016\u001cHOT1nKV\tA\n\u0005\u0002N\u001d6\t\u0011#\u0003\u0002P#\t12)\u00198dK2\u0014V-];fgR\fV/Z;f\u001d\u0006lW-\u0001\ndC:\u001cW\r\u001c*fcV,7\u000f\u001e(b[\u0016\u0004\u0013!D2p]\u001aLw-\u001e:bi&|g.F\u0001T!\tiE+\u0003\u0002V#\tq\"+\u00192cSRl\u0015kV8sWF+X-^3D_:4\u0017nZ;sCRLwN\\\u0001\u000fG>tg-[4ve\u0006$\u0018n\u001c8!\u0003\u0019a\u0014N\\5u}Q1\u0011LW.];z\u0003\"!\u0014\u0001\t\u000b%Z\u0001\u0019A\u0016\t\u000bQZ\u0001\u0019\u0001\u001c\t\u000byZ\u0001\u0019\u0001!\t\u000b)[\u0001\u0019\u0001'\t\u000bE[\u0001\u0019A*)\u0005-\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003\u0019IgN[3di*\tQ-A\u0003kCZ\f\u00070\u0003\u0002hE\n1\u0011J\u001c6fGR\fq\u0006R#G\u0003VcEkX!E\t&#\u0016j\u0014(B\u0019~KeJR(S\u001b\u0006#\u0016j\u0014(`!>cE*\u0013(H?&sE+\u0012*W\u00032+\u0012A\u001b\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fA\u0001^5nK*\tq.\u0001\u0003kCZ\f\u0017BA9m\u0005!!UO]1uS>t\u0017\u0001\r#F\r\u0006+F\nV0B\t\u0012KE+S(O\u00032{\u0016J\u0014$P%6\u000bE+S(O?B{E\nT%O\u000f~Ke\nV#S-\u0006c\u0005%A\u0003baBd\u0017\u0010\u0006\u0002vqB\u0011QJ^\u0005\u0003oF\u0011\u0011CU1cE&$X*U,pe.\fV/Z;f\u0011\u0015Ih\u00021\u0001{\u0003M)g/\u001a8u'>,(oY5oONK8\u000f^3n!\tYX0D\u0001}\u0015\t!r#\u0003\u0002\u007fy\n\u0019RI^3oiN{WO]2j]\u001e\u001c\u0016p\u001d;f[R)Q/!\u0001\u0002\u0004!)\u0011p\u0004a\u0001u\"1\u0011QA\bA\u0002)\fA%\u00193eSRLwN\\1m\u0013:4wN]7bi&|g\u000eU8mY&tw-\u00138uKJ4\u0018\r\u001c\u0015\u0004\u001f\u0005%\u0001\u0003BA\u0006\u0003;i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u0002\u0014\u0005U\u0011AB2p[6|gN\u0003\u0003\u0002\u0018\u0005e\u0011AB4p_\u001edWM\u0003\u0002\u0002\u001c\u0005\u00191m\\7\n\t\u0005}\u0011Q\u0002\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0007")
public class RabbitMQWorkQueueSupplier
implements WorkQueueSupplier {
    private final Sender sender;
    private final ReceiverProvider receiverProvider;
    private final JsonTaskSerializer jsonTaskSerializer;
    private final CancelRequestQueueName cancelRequestName;
    private final RabbitMQWorkQueueConfiguration configuration;
    private final Duration DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL;

    private Sender sender() {
        return this.sender;
    }

    private ReceiverProvider receiverProvider() {
        return this.receiverProvider;
    }

    private JsonTaskSerializer jsonTaskSerializer() {
        return this.jsonTaskSerializer;
    }

    private CancelRequestQueueName cancelRequestName() {
        return this.cancelRequestName;
    }

    private RabbitMQWorkQueueConfiguration configuration() {
        return this.configuration;
    }

    public Duration DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL() {
        return this.DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL;
    }

    public RabbitMQWorkQueue apply(EventSourcingSystem eventSourcingSystem) {
        return this.apply(eventSourcingSystem, this.DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL());
    }

    @VisibleForTesting
    public RabbitMQWorkQueue apply(EventSourcingSystem eventSourcingSystem, Duration additionalInformationPollingInterval) {
        WorkerStatusListener listener = new WorkerStatusListener(eventSourcingSystem);
        SerialTaskManagerWorker worker = new SerialTaskManagerWorker((TaskManagerWorker.Listener)listener, additionalInformationPollingInterval);
        RabbitMQWorkQueue rabbitMQWorkQueue = new RabbitMQWorkQueue((TaskManagerWorker)worker, this.sender(), this.receiverProvider(), this.jsonTaskSerializer(), this.configuration(), this.cancelRequestName());
        return rabbitMQWorkQueue;
    }

    @Inject
    public RabbitMQWorkQueueSupplier(Sender sender, ReceiverProvider receiverProvider, JsonTaskSerializer jsonTaskSerializer, CancelRequestQueueName cancelRequestName, RabbitMQWorkQueueConfiguration configuration) {
        this.sender = sender;
        this.receiverProvider = receiverProvider;
        this.jsonTaskSerializer = jsonTaskSerializer;
        this.cancelRequestName = cancelRequestName;
        this.configuration = configuration;
        this.DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL = Duration.ofSeconds(30L);
    }
}

