/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.blob.api.BucketName;

public class BucketNameResolver {
    private final Optional<BucketName> namespace;
    private final Optional<String> prefix;

    static Builder.RequirePrefix builder() {
        return prefix -> namespace -> new Builder.ReadyToBuild(namespace, prefix);
    }

    private BucketNameResolver(Optional<BucketName> namespace, Optional<String> prefix) {
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(prefix);
        this.namespace = namespace;
        this.prefix = prefix;
    }

    BucketName resolve(BucketName bucketName) {
        Preconditions.checkNotNull((Object)bucketName);
        if (this.isNameSpace(bucketName)) {
            return bucketName;
        }
        return this.prefix.map(bucketPrefix -> BucketName.of((String)(bucketPrefix + bucketName.asString()))).orElse(bucketName);
    }

    private boolean isNameSpace(BucketName bucketName) {
        return this.namespace.map(existingNamespace -> existingNamespace.equals((Object)bucketName)).orElse(false);
    }

    static class Builder {
        Builder() {
        }

        static final class ReadyToBuild {
            private final Optional<BucketName> namespace;
            private final Optional<String> prefix;

            ReadyToBuild(Optional<BucketName> namespace, Optional<String> prefix) {
                this.namespace = namespace;
                this.prefix = prefix;
            }

            BucketNameResolver build() {
                return new BucketNameResolver(this.namespace, this.prefix);
            }
        }

        @FunctionalInterface
        static interface RequireNamespace {
            public ReadyToBuild namespace(Optional<BucketName> var1);

            default public ReadyToBuild namespace(BucketName namespace) {
                return this.namespace(Optional.ofNullable(namespace));
            }

            default public ReadyToBuild noNamespace() {
                return this.namespace(Optional.empty());
            }
        }

        @FunctionalInterface
        static interface RequirePrefix {
            public RequireNamespace prefix(Optional<String> var1);

            default public RequireNamespace noPrefix() {
                return this.prefix(Optional.empty());
            }

            default public RequireNamespace prefix(String prefix) {
                return this.prefix(Optional.ofNullable(prefix));
            }
        }
    }
}

