/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;

public class AwsS3AuthConfiguration {
    private final URI endpoint;
    private final String accessKeyId;
    private final String secretKey;

    public static Builder.RequiredEndpoint builder() {
        return endpoint -> accessKeyId -> secretKey -> new Builder.ReadyToBuild(endpoint, accessKeyId, secretKey);
    }

    private AwsS3AuthConfiguration(URI endpoint, String accessKeyId, String secretKey) {
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.secretKey = secretKey;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public final boolean equals(Object o) {
        if (o instanceof AwsS3AuthConfiguration) {
            AwsS3AuthConfiguration that = (AwsS3AuthConfiguration)o;
            return Objects.equal((Object)this.endpoint, (Object)that.endpoint) && Objects.equal((Object)this.accessKeyId, (Object)that.accessKeyId) && Objects.equal((Object)this.secretKey, (Object)that.secretKey);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.endpoint, this.accessKeyId, this.secretKey});
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("endpoint", (Object)this.endpoint).add("accessKeyId", (Object)this.accessKeyId).add("secretKey", (Object)this.secretKey).toString();
    }

    public static interface Builder {

        public static class ReadyToBuild {
            private final URI endpoint;
            private final String accessKeyId;
            private final String secretKey;

            public ReadyToBuild(URI endpoint, String accessKeyId, String secretKey) {
                this.endpoint = endpoint;
                this.accessKeyId = accessKeyId;
                this.secretKey = secretKey;
            }

            public AwsS3AuthConfiguration build() {
                Preconditions.checkNotNull((Object)this.endpoint, (Object)"'endpoint' is mandatory");
                Preconditions.checkNotNull((Object)this.accessKeyId, (Object)"'accessKeyId' is mandatory");
                Preconditions.checkArgument((!this.accessKeyId.isEmpty() ? 1 : 0) != 0, (Object)"'accessKeyId' is mandatory");
                Preconditions.checkNotNull((Object)this.secretKey, (Object)"'secretKey' is mandatory");
                Preconditions.checkArgument((!this.secretKey.isEmpty() ? 1 : 0) != 0, (Object)"'secretKey' is mandatory");
                return new AwsS3AuthConfiguration(this.endpoint, this.accessKeyId, this.secretKey);
            }
        }

        @FunctionalInterface
        public static interface RequiredSecretKey {
            public ReadyToBuild secretKey(String var1);
        }

        @FunctionalInterface
        public static interface RequiredAccessKeyId {
            public RequiredSecretKey accessKeyId(String var1);
        }

        @FunctionalInterface
        public static interface RequiredEndpoint {
            public RequiredAccessKeyId endpoint(URI var1);
        }
    }
}

