/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import org.apache.james.user.lib.model.Algorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestUtil.class);

    public static void main(String[] args) {
        String alg = "SHA";
        boolean file = false;
        if (args.length == 0 || args.length > 4) {
            DigestUtil.printUsage();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String currArg = args[i].toLowerCase(Locale.US);
            if (currArg.equals("-help") || currArg.equals("-usage")) {
                DigestUtil.printUsage();
                return;
            }
            if (currArg.equals("-alg")) {
                alg = args[i + 1];
            }
            if (!currArg.equals("-file")) continue;
            file = true;
        }
        if (file) {
            DigestUtil.digestFile(args[args.length - 1], alg);
        } else {
            try {
                String hash = DigestUtil.digestString(args[args.length - 1], Algorithm.DEFAULT_FACTORY.of(alg));
                System.out.println("Hash is: " + hash);
            }
            catch (NoSuchAlgorithmException nsae) {
                System.out.println("No such algorithm available");
            }
        }
    }

    public static void printUsage() {
        System.out.println("Usage: java org.apache.james.security.DigestUtil [-alg algorithm] [-file] filename|string");
    }

    public static void digestFile(String filename, String algorithm) {
        byte[] b = new byte[65536];
        try (FileInputStream fis = new FileInputStream(filename);){
            MessageDigest md = MessageDigest.getInstance(algorithm);
            while (fis.available() > 0) {
                int read = fis.read(b);
                md.update(b, 0, read);
            }
            byte[] digest = md.digest();
            String fileNameBuffer = filename + "." + algorithm;
            try (FileOutputStream fos = new FileOutputStream(fileNameBuffer);){
                OutputStream encodedStream = MimeUtility.encode((OutputStream)fos, (String)"base64");
                encodedStream.write(digest);
                fos.flush();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error computing Digest", (Throwable)e);
        }
    }

    public static String digestString(String pass, Algorithm algorithm) throws NoSuchAlgorithmException {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm.asString());
            byte[] digest = md.digest(pass.getBytes(StandardCharsets.ISO_8859_1));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStream encodedStream = MimeUtility.encode((OutputStream)bos, (String)"base64");
            encodedStream.write(digest);
            if (!algorithm.isLegacy()) {
                encodedStream.close();
            }
            return bos.toString(StandardCharsets.ISO_8859_1);
        }
        catch (IOException | MessagingException e) {
            throw new RuntimeException("Fatal error", e);
        }
    }

    private DigestUtil() {
    }
}

