/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.vacation;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.vacation.Vacation;
import org.apache.james.jmap.api.vacation.VacationPatch;
import org.apache.james.jmap.api.vacation.VacationRepository;
import reactor.core.publisher.Mono;

public class MemoryVacationRepository
implements VacationRepository {
    private final Map<AccountId, Vacation> vacationMap = new HashMap<AccountId, Vacation>();

    @Override
    public Mono<Vacation> retrieveVacation(AccountId accountId) {
        Preconditions.checkNotNull((Object)accountId);
        return Mono.just((Object)this.vacationMap.getOrDefault(accountId, DEFAULT_VACATION));
    }

    @Override
    public Mono<Void> modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)vacationPatch);
        return this.retrieveVacation(accountId).doOnNext(oldVacation -> this.vacationMap.put(accountId, vacationPatch.patch((Vacation)oldVacation))).then();
    }
}

