/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.projections;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.time.ZonedDateTime;
import java.util.Comparator;
import javax.inject.Inject;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.streams.Limit;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryEmailQueryView
implements EmailQueryView {
    private final Table<MailboxId, MessageId, EmailQueryView.Entry> entries = Tables.synchronizedTable((Table)HashBasedTable.create());

    @Inject
    public MemoryEmailQueryView() {
    }

    @Override
    public Flux<MessageId> listMailboxContent(MailboxId mailboxId, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        return Flux.fromIterable(this.entries.row((Object)mailboxId).values()).sort(Comparator.comparing(EmailQueryView.Entry::getSentAt).reversed()).map(EmailQueryView.Entry::getMessageId).take((long)((Integer)limit.getLimit().get()).intValue());
    }

    @Override
    public Flux<MessageId> listMailboxContentSinceSentAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        return Flux.fromIterable(this.entries.row((Object)mailboxId).values()).filter(e -> e.getSentAt().isAfter(since) || e.getSentAt().isEqual(since)).sort(Comparator.comparing(EmailQueryView.Entry::getSentAt).reversed()).map(EmailQueryView.Entry::getMessageId).take((long)((Integer)limit.getLimit().get()).intValue());
    }

    @Override
    public Flux<MessageId> listMailboxContentSinceReceivedAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        return Flux.fromIterable(this.entries.row((Object)mailboxId).values()).filter(e -> e.getReceivedAt().isAfter(since) || e.getReceivedAt().isEqual(since)).sort(Comparator.comparing(EmailQueryView.Entry::getSentAt).reversed()).map(EmailQueryView.Entry::getMessageId).take((long)((Integer)limit.getLimit().get()).intValue());
    }

    @Override
    public Mono<Void> delete(MailboxId mailboxId, MessageId messageId) {
        return Mono.fromRunnable(() -> this.entries.remove((Object)mailboxId, (Object)messageId));
    }

    @Override
    public Mono<Void> delete(MailboxId mailboxId) {
        return Mono.fromRunnable(() -> this.entries.row((Object)mailboxId).clear());
    }

    @Override
    public Mono<Void> save(MailboxId mailboxId, ZonedDateTime sentAt, ZonedDateTime receivedAt, MessageId messageId) {
        return Mono.fromRunnable(() -> this.entries.put((Object)mailboxId, (Object)messageId, (Object)new EmailQueryView.Entry(mailboxId, messageId, sentAt, receivedAt)));
    }
}

