/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.vault.routes;

import com.fasterxml.jackson.databind.Module;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.vault.DeletedMessageVault;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.dto.query.QueryTranslator;
import org.apache.james.vault.search.Query;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskIdDto;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.vault.routes.DeletedMessagesVaultDeleteTask;
import org.apache.james.webadmin.vault.routes.DeletedMessagesVaultExportTask;
import org.apache.james.webadmin.vault.routes.DeletedMessagesVaultRestoreTask;
import org.apache.james.webadmin.vault.routes.ExportService;
import org.apache.james.webadmin.vault.routes.RestoreService;
import spark.Request;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

@Api(tags={"Deleted Messages Vault"})
@Path(value="deletedMessages")
@Produces(value={"application/json"})
public class DeletedMessagesVaultRoutes
implements Routes {
    private static final TaskRegistrationKey EXPORT_REGISTRATION_KEY = TaskRegistrationKey.of((String)"export");
    private static final TaskRegistrationKey RESTORE_REGISTRATION_KEY = TaskRegistrationKey.of((String)"restore");
    private static final TaskRegistrationKey EXPIRED_REGISTRATION_KEY = TaskRegistrationKey.of((String)"expired");
    public static final String ROOT_PATH = "deletedMessages";
    public static final String USERS = "users";
    public static final String MESSAGE_PATH_PARAM = "messages";
    private static final String USER_PATH_PARAM = ":user";
    private static final String MESSAGE_ID_PARAM = ":messageId";
    static final String USER_PATH = "deletedMessages/users/:user";
    private static final String DELETE_PATH = "deletedMessages/users/:user/messages/:messageId";
    private static final String SCOPE_QUERY_PARAM = "scope";
    private static final String EXPORT_TO_QUERY_PARAM = "exportTo";
    private final RestoreService vaultRestore;
    private final ExportService vaultExport;
    private final DeletedMessageVault deletedMessageVault;
    private final JsonTransformer jsonTransformer;
    private final TaskManager taskManager;
    private final JsonExtractor<QueryElement> jsonExtractor;
    private final QueryTranslator queryTranslator;
    private final UsersRepository usersRepository;
    private final MessageId.Factory messageIdFactory;

    @Inject
    @VisibleForTesting
    DeletedMessagesVaultRoutes(DeletedMessageVault deletedMessageVault, RestoreService vaultRestore, ExportService vaultExport, JsonTransformer jsonTransformer, TaskManager taskManager, QueryTranslator queryTranslator, UsersRepository usersRepository, MessageId.Factory messageIdFactory) {
        this.deletedMessageVault = deletedMessageVault;
        this.vaultRestore = vaultRestore;
        this.vaultExport = vaultExport;
        this.jsonTransformer = jsonTransformer;
        this.taskManager = taskManager;
        this.queryTranslator = queryTranslator;
        this.usersRepository = usersRepository;
        this.jsonExtractor = new JsonExtractor(QueryElement.class, new Module[0]);
        this.messageIdFactory = messageIdFactory;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.post(USER_PATH, this.userActions(), (ResponseTransformer)this.jsonTransformer);
        service.delete(ROOT_PATH, this.deleteWithScope(), (ResponseTransformer)this.jsonTransformer);
        TaskFromRequest deleteTaskFromRequest = this::deleteMessage;
        service.delete(DELETE_PATH, deleteTaskFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    @POST
    @Path(value="users/{user}")
    @ApiOperation(value="Restore deleted emails from a specified user to his new restore mailbox or export their content to a destination mail address")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="user", paramType="path parameter", dataType="String", defaultValue="none", example="user@james.org", value="Compulsory. Needs to be a valid username represent for an user had requested to restore deleted emails"), @ApiImplicitParam(required=true, dataType="String", name="action", paramType="query", example="?action=restore", value="Compulsory. Needs to be a valid action represent for an operation to perform on the Deleted Message Vault, valid action should be in the list (restore, export)"), @ApiImplicitParam(dataType="String", name="exportTo", paramType="query", example="?exportTo=user@james.org", value="Compulsory if action is export. Needs to be a valid mail address. The content of the vault matching the query will be sent to that address")})
    @ApiResponses(value={@ApiResponse(code=201, message="Task is created", response=TaskIdDto.class), @ApiResponse(code=400, message="Bad request - user param is invalid"), @ApiResponse(code=404, message="Not found - requested user does not exist"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    private Route userActions() {
        return TaskFromRequestRegistry.builder().register(EXPORT_REGISTRATION_KEY, this::export).register(RESTORE_REGISTRATION_KEY, this::restore).buildAsRoute(this.taskManager);
    }

    private Task export(Request request) throws JsonExtractException {
        Username username = this.extractUser(request);
        this.validateUserExist(username);
        return new DeletedMessagesVaultExportTask(this.vaultExport, username, this.extractQuery(request), this.extractMailAddress(request));
    }

    private Task restore(Request request) throws JsonExtractException {
        Username username = this.extractUser(request);
        this.validateUserExist(username);
        return new DeletedMessagesVaultRestoreTask(this.vaultRestore, username, this.extractQuery(request));
    }

    @DELETE
    @ApiOperation(value="Purge all expired messages based on retentionPeriod of deletedMessageVault configuration")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="scope", dataType="String", paramType="query", example="?scope=expired", value="Compulsory. Needs to be a purge action")})
    @ApiResponses(value={@ApiResponse(code=201, message="Task is created", response=TaskIdDto.class), @ApiResponse(code=400, message="Bad request - action is invalid"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    private Route deleteWithScope() {
        return TaskFromRequestRegistry.builder().parameterName(SCOPE_QUERY_PARAM).register(EXPIRED_REGISTRATION_KEY, request -> this.deletedMessageVault.deleteExpiredMessagesTask()).buildAsRoute(this.taskManager);
    }

    @DELETE
    @Path(value="users/{user}/messages/{messageId}")
    @ApiOperation(value="Delete message with messageId")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="user", paramType="path parameter", dataType="String", defaultValue="none", example="user0@james.org", value="Compulsory. Needs to be a valid username represent for an user had requested to restore deleted emails"), @ApiImplicitParam(required=true, name="messageId", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory, Need to be a valid messageId")})
    @ApiResponses(value={@ApiResponse(code=201, message="Task is created", response=TaskIdDto.class), @ApiResponse(code=400, message="Bad request - user param is invalid"), @ApiResponse(code=400, message="Bad request - messageId param is invalid"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    private Task deleteMessage(Request request) {
        Username username = this.extractUser(request);
        this.validateUserExist(username);
        MessageId messageId = this.parseMessageId(request);
        return new DeletedMessagesVaultDeleteTask(this.deletedMessageVault, username, messageId);
    }

    private void validateUserExist(Username username) {
        try {
            if (!this.usersRepository.contains(username)) {
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("User '%s' does not exist in the system", new Object[]{username.asString()}).haltError();
            }
        }
        catch (UsersRepositoryException e) {
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message("Unable to validate 'user' parameter").cause((Exception)((Object)e)).haltError();
        }
    }

    private MailAddress extractMailAddress(Request request) {
        return Optional.ofNullable(request.queryParams(EXPORT_TO_QUERY_PARAM)).filter(StringUtils::isNotBlank).map(this::parseToMailAddress).orElseThrow(() -> ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid 'exportTo' parameter, null or blank value is not accepted").haltError());
    }

    private MailAddress parseToMailAddress(String addressString) {
        try {
            return new MailAddress(addressString);
        }
        catch (AddressException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid 'exportTo' parameter").cause((Exception)((Object)e)).haltError();
        }
    }

    private Query extractQuery(Request request) throws JsonExtractException {
        try {
            QueryElement queryElement = (QueryElement)this.jsonExtractor.parse(request.body());
            return this.queryTranslator.translate(queryElement);
        }
        catch (QueryTranslator.QueryTranslatorException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid payload passing to the route").cause((Exception)((Object)e)).haltError();
        }
    }

    private Username extractUser(Request request) {
        try {
            return Username.of((String)request.params(USER_PATH_PARAM));
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid 'user' parameter").cause((Exception)e).haltError();
        }
    }

    private MessageId parseMessageId(Request request) {
        String messageIdAsString = request.params(MESSAGE_ID_PARAM);
        try {
            return this.messageIdFactory.fromString(messageIdAsString);
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).message("Can not deserialize the supplied messageId: %s", new Object[]{messageIdAsString}).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).haltError();
        }
    }
}

