/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.rabbitmq;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.Param;
import feign.RequestInterceptor;
import feign.RequestLine;
import feign.RetryableException;
import feign.Retryer;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;

public interface RabbitMQManagementAPI {
    public static final ErrorDecoder RETRY_500 = (methodKey, response) -> {
        if (response.status() == 500) {
            throw new RetryableException(response.status(), "Error encountered, scheduling retry", response.request().httpMethod(), new Date());
        }
        throw new RuntimeException("Non recoverable exception status: " + response.status());
    };

    public static RabbitMQManagementAPI from(RabbitMQConfiguration configuration) {
        try {
            RabbitMQConfiguration.ManagementCredentials credentials = configuration.getManagementCredentials();
            RabbitMQManagementAPI rabbitMQManagementAPI = (RabbitMQManagementAPI)Feign.builder().client(RabbitMQManagementAPI.getClient(configuration)).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(credentials.getUser(), new String(credentials.getPassword()))).logger((Logger)new Slf4jLogger(RabbitMQManagementAPI.class)).logLevel(Logger.Level.FULL).encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).retryer((Retryer)new Retryer.Default()).errorDecoder(RETRY_500).target(RabbitMQManagementAPI.class, configuration.getManagementUri().toString());
            return rabbitMQManagementAPI;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static Client getClient(RabbitMQConfiguration configuration) throws KeyManagementException, NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
        if (configuration.useSslManagement().booleanValue()) {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            RabbitMQManagementAPI.setupSslValidationStrategy(sslContextBuilder, configuration);
            RabbitMQManagementAPI.setupClientCertificateAuthentication(sslContextBuilder, configuration);
            SSLContext sslContext = sslContextBuilder.build();
            return new Client.Default(sslContext.getSocketFactory(), RabbitMQManagementAPI.getHostNameVerifier(configuration));
        }
        return new Client.Default(null, null);
    }

    private static HostnameVerifier getHostNameVerifier(RabbitMQConfiguration configuration) {
        switch (configuration.getSslConfiguration().getHostNameVerifier()) {
            case ACCEPT_ANY_HOSTNAME: {
                return (hostname, session) -> true;
            }
        }
        return new DefaultHostnameVerifier();
    }

    private static void setupClientCertificateAuthentication(SSLContextBuilder sslContextBuilder, RabbitMQConfiguration configuration) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        Optional<RabbitMQConfiguration.SSLConfiguration.SSLKeyStore> keyStore = configuration.getSslConfiguration().getKeyStore();
        if (keyStore.isPresent()) {
            RabbitMQConfiguration.SSLConfiguration.SSLKeyStore sslKeyStore = keyStore.get();
            sslContextBuilder.loadKeyMaterial(sslKeyStore.getFile(), sslKeyStore.getPassword(), sslKeyStore.getPassword());
        }
    }

    private static void setupSslValidationStrategy(SSLContextBuilder sslContextBuilder, RabbitMQConfiguration configuration) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        RabbitMQConfiguration.SSLConfiguration.SSLValidationStrategy strategy = configuration.getSslConfiguration().getStrategy();
        TrustStrategy TRUST_ALL = (x509Certificates, authType) -> true;
        switch (strategy) {
            case DEFAULT: {
                break;
            }
            case IGNORE: {
                sslContextBuilder.loadTrustMaterial(TRUST_ALL);
                break;
            }
            case OVERRIDE: {
                RabbitMQManagementAPI.applyTrustStore(sslContextBuilder, configuration);
                break;
            }
            default: {
                throw new NotImplementedException(String.format("unrecognized strategy '%s'", strategy.name()));
            }
        }
    }

    private static SSLContextBuilder applyTrustStore(SSLContextBuilder sslContextBuilder, RabbitMQConfiguration configuration) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        RabbitMQConfiguration.SSLConfiguration.SSLTrustStore trustStore = configuration.getSslConfiguration().getTrustStore().orElseThrow(() -> new IllegalStateException("SSLTrustStore cannot to be empty"));
        return sslContextBuilder.loadTrustMaterial(trustStore.getFile(), trustStore.getPassword());
    }

    @RequestLine(value="GET /api/queues")
    public List<MessageQueue> listQueues();

    @RequestLine(value="GET /api/queues/{vhost}/{name}", decodeSlash=false)
    public MessageQueueDetails queueDetails(@Param(value="vhost") String var1, @Param(value="name") String var2);

    @RequestLine(value="DELETE /api/queues/{vhost}/{name}", decodeSlash=false)
    public void deleteQueue(@Param(value="vhost") String var1, @Param(value="name") String var2);

    @RequestLine(value="GET /api/exchanges/{vhost}/{name}/bindings/source", decodeSlash=false)
    public List<BindingSource> listBindings(@Param(value="vhost") String var1, @Param(value="name") String var2);

    @RequestLine(value="GET /api/exchanges")
    public List<Exchange> listExchanges();

    public static class BindingSource {
        private final String source;
        private final String vhost;
        private final String destination;
        private final String destinationType;
        private final String routingKey;
        private final Map<String, String> arguments;
        private final String propertiesKey;

        public BindingSource(@JsonProperty(value="source") String source, @JsonProperty(value="vhost") String vhost, @JsonProperty(value="destination") String destination, @JsonProperty(value="destination_type") String destinationType, @JsonProperty(value="routing_key") String routingKey, @JsonProperty(value="arguments") Map<String, String> arguments, @JsonProperty(value="properties_key") String propertiesKey) {
            this.source = source;
            this.vhost = vhost;
            this.destination = destination;
            this.destinationType = destinationType;
            this.routingKey = routingKey;
            this.arguments = arguments;
            this.propertiesKey = propertiesKey;
        }

        public String getSource() {
            return this.source;
        }

        public String getVhost() {
            return this.vhost;
        }

        public String getDestination() {
            return this.destination;
        }

        public String getDestinationType() {
            return this.destinationType;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }

        public Map<String, String> getArguments() {
            return this.arguments;
        }

        public String getPropertiesKey() {
            return this.propertiesKey;
        }

        public final boolean equals(Object o) {
            if (o instanceof BindingSource) {
                BindingSource that = (BindingSource)o;
                return Objects.equals(this.source, that.source) && Objects.equals(this.vhost, that.vhost) && Objects.equals(this.destination, that.destination) && Objects.equals(this.destinationType, that.destinationType) && Objects.equals(this.routingKey, that.routingKey) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.propertiesKey, that.propertiesKey);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.source, this.vhost, this.destination, this.destinationType, this.routingKey, this.arguments, this.propertiesKey);
        }
    }

    public static class Exchange {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="type")
        String type;
        @JsonProperty(value="auto_delete")
        boolean autoDelete;
        @JsonProperty(value="durable")
        boolean durable;
        @JsonProperty(value="internal")
        boolean internal;
        @JsonProperty(value="arguments")
        Map<String, String> arguments;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isAutoDelete() {
            return this.autoDelete;
        }

        public boolean isDurable() {
            return this.durable;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public Map<String, String> getArguments() {
            return this.arguments;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("autoDelete", this.autoDelete).add("durable", this.durable).add("internal", this.internal).add("arguments", this.arguments).toString();
        }
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public static enum ActivityStatus {
        Waiting("waiting"),
        SingleActive("single_active");

        private final String value;

        private ActivityStatus(String value) {
            this.value = value;
        }

        @JsonValue
        String getValue() {
            return this.value;
        }
    }

    public static class ConsumerDetails {
        @JsonProperty(value="consumer_tag")
        String tag;
        @JsonProperty(value="activity_status")
        ActivityStatus status;

        public ActivityStatus getStatus() {
            return this.status;
        }

        public String getTag() {
            return this.tag;
        }
    }

    public static class MessageQueueDetails {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="vhost")
        String vhost;
        @JsonProperty(value="auto_delete")
        boolean autoDelete;
        @JsonProperty(value="durable")
        boolean durable;
        @JsonProperty(value="exclusive")
        boolean exclusive;
        @JsonProperty(value="arguments")
        Map<String, String> arguments;
        @JsonProperty(value="consumer_details")
        List<ConsumerDetails> consumerDetails;

        public String getName() {
            return this.name;
        }

        public String getVhost() {
            return this.vhost;
        }

        public boolean isAutoDelete() {
            return this.autoDelete;
        }

        public boolean isDurable() {
            return this.durable;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public Map<String, String> getArguments() {
            return this.arguments;
        }

        public List<ConsumerDetails> getConsumerDetails() {
            return this.consumerDetails;
        }
    }

    public static class MessageQueue {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="vhost")
        String vhost;
        @JsonProperty(value="auto_delete")
        boolean autoDelete;
        @JsonProperty(value="durable")
        boolean durable;
        @JsonProperty(value="exclusive")
        boolean exclusive;
        @JsonProperty(value="arguments")
        Map<String, String> arguments;

        public String getName() {
            return this.name;
        }

        public String getVhost() {
            return this.vhost;
        }

        public boolean isAutoDelete() {
            return this.autoDelete;
        }

        public boolean isDurable() {
            return this.durable;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public Map<String, String> getArguments() {
            return this.arguments;
        }
    }
}

