/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.rabbitmq;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Optional;
import javax.inject.Inject;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class RabbitMQConnectionFactory {
    private static final TrustStrategy TRUST_ALL = (x509Certificates, authType) -> true;
    private final ConnectionFactory connectionFactory;
    private final RabbitMQConfiguration configuration;

    @Inject
    public RabbitMQConnectionFactory(RabbitMQConfiguration rabbitMQConfiguration) {
        this.configuration = rabbitMQConfiguration;
        this.connectionFactory = this.from(rabbitMQConfiguration);
    }

    private ConnectionFactory from(RabbitMQConfiguration rabbitMQConfiguration) {
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setUri(rabbitMQConfiguration.getUri());
            connectionFactory.setHandshakeTimeout(rabbitMQConfiguration.getHandshakeTimeoutInMs());
            connectionFactory.setShutdownTimeout(rabbitMQConfiguration.getShutdownTimeoutInMs());
            connectionFactory.setChannelRpcTimeout(rabbitMQConfiguration.getChannelRpcTimeoutInMs());
            connectionFactory.setConnectionTimeout(rabbitMQConfiguration.getConnectionTimeoutInMs());
            connectionFactory.setNetworkRecoveryInterval(rabbitMQConfiguration.getNetworkRecoveryIntervalInMs());
            connectionFactory.setUsername(rabbitMQConfiguration.getManagementCredentials().getUser());
            connectionFactory.setPassword(String.valueOf(rabbitMQConfiguration.getManagementCredentials().getPassword()));
            if (this.configuration.useSsl().booleanValue()) {
                this.setupSslConfiguration(connectionFactory);
            }
            return connectionFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setupSslConfiguration(ConnectionFactory connectionFactory) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException {
        connectionFactory.useSslProtocol(this.sslContext(this.configuration));
        this.setupHostNameVerification(connectionFactory);
    }

    private SSLContext sslContext(RabbitMQConfiguration configuration) throws KeyManagementException, NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        RabbitMQConfiguration.SSLConfiguration sslConfiguration = configuration.getSslConfiguration();
        this.setupSslValidationStrategy(sslContextBuilder, sslConfiguration);
        this.setupClientCertificateAuthentication(sslContextBuilder, sslConfiguration);
        return sslContextBuilder.build();
    }

    private void setupClientCertificateAuthentication(SSLContextBuilder sslContextBuilder, RabbitMQConfiguration.SSLConfiguration sslConfiguration) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        Optional<RabbitMQConfiguration.SSLConfiguration.SSLKeyStore> keyStore = sslConfiguration.getKeyStore();
        if (keyStore.isPresent()) {
            RabbitMQConfiguration.SSLConfiguration.SSLKeyStore sslKeyStore = keyStore.get();
            sslContextBuilder.loadKeyMaterial(sslKeyStore.getFile(), sslKeyStore.getPassword(), sslKeyStore.getPassword());
        }
    }

    private void setupSslValidationStrategy(SSLContextBuilder sslContextBuilder, RabbitMQConfiguration.SSLConfiguration sslConfiguration) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        RabbitMQConfiguration.SSLConfiguration.SSLValidationStrategy strategy = sslConfiguration.getStrategy();
        switch (strategy) {
            case DEFAULT: {
                break;
            }
            case IGNORE: {
                sslContextBuilder.loadTrustMaterial(TRUST_ALL);
                break;
            }
            case OVERRIDE: {
                this.applyTrustStore(sslContextBuilder);
                break;
            }
            default: {
                throw new NotImplementedException(String.format("unrecognized strategy '%s'", strategy.name()));
            }
        }
    }

    private SSLContextBuilder applyTrustStore(SSLContextBuilder sslContextBuilder) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        RabbitMQConfiguration.SSLConfiguration.SSLTrustStore trustStore = this.configuration.getSslConfiguration().getTrustStore().orElseThrow(() -> new IllegalStateException("SSLTrustStore cannot to be empty"));
        return sslContextBuilder.loadTrustMaterial(trustStore.getFile(), trustStore.getPassword());
    }

    private void setupHostNameVerification(ConnectionFactory connectionFactory) {
        RabbitMQConfiguration.SSLConfiguration.HostNameVerifier hostNameVerifier = this.configuration.getSslConfiguration().getHostNameVerifier();
        if (hostNameVerifier == RabbitMQConfiguration.SSLConfiguration.HostNameVerifier.DEFAULT) {
            connectionFactory.enableHostnameVerification();
        }
    }

    Connection create() {
        return (Connection)this.connectionMono().block();
    }

    Mono<Connection> connectionMono() {
        return Mono.fromCallable(() -> ((ConnectionFactory)this.connectionFactory).newConnection()).retryWhen((Retry)Retry.backoff((long)this.configuration.getMaxRetries(), (Duration)Duration.ofMillis(this.configuration.getMinDelayInMs())).scheduler(Schedulers.elastic()));
    }
}

