/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.annotations.VisibleForTesting;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import reactor.core.publisher.Mono;

public class UserProvisioner {
    private final UsersRepository usersRepository;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    UserProvisioner(UsersRepository usersRepository, MetricFactory metricFactory) {
        this.usersRepository = usersRepository;
        this.metricFactory = metricFactory;
    }

    public Mono<Void> provisionUser(MailboxSession session) {
        if (session != null && !this.usersRepository.isReadOnly()) {
            return Mono.fromRunnable(() -> this.createAccountIfNeeded(session));
        }
        return Mono.empty();
    }

    private void createAccountIfNeeded(MailboxSession session) {
        TimeMetric timeMetric = this.metricFactory.timer("JMAP-user-provisioning");
        try {
            Username username = session.getUser();
            if (this.needsAccountCreation(username)) {
                this.createAccount(username);
            }
        }
        catch (AlreadyExistInUsersRepositoryException username) {
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
        finally {
            timeMetric.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD);
        }
    }

    private void createAccount(Username username) throws UsersRepositoryException {
        this.usersRepository.addUser(username, this.generatePassword());
    }

    private boolean needsAccountCreation(Username username) throws UsersRepositoryException {
        return !this.usersRepository.contains(username);
    }

    private String generatePassword() {
        return UUID.randomUUID().toString();
    }
}

