/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils.quotas;

import javax.inject.Inject;
import org.apache.james.jmap.draft.model.mailbox.Quotas;
import org.apache.james.jmap.draft.utils.quotas.QuotaLoader;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;

public class DefaultQuotaLoader
extends QuotaLoader {
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;

    @Inject
    public DefaultQuotaLoader(QuotaRootResolver quotaRootResolver, QuotaManager quotaManager) {
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
    }

    @Override
    public Quotas getQuotas(MailboxPath mailboxPath) throws MailboxException {
        QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(mailboxPath);
        Quotas.QuotaId quotaId = Quotas.QuotaId.fromQuotaRoot(quotaRoot);
        QuotaManager.Quotas quotas = this.quotaManager.getQuotas(quotaRoot);
        return Quotas.from(quotaId, Quotas.Quota.from(this.quotaToValue(quotas.getStorageQuota()), this.quotaToValue(quotas.getMessageQuota())));
    }
}

