/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.ibm.icu.text.UnicodeSet;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.commons.lang3.StringUtils;

public class Keyword {
    private static final int FLAG_NAME_MIN_LENGTH = 1;
    private static final int FLAG_NAME_MAX_LENGTH = 255;
    private static final UnicodeSet FLAG_NAME_PATTERN = new UnicodeSet("[[a-z][A-Z][0-9]]").add(36).add(95).add(45).freeze();
    public static final Keyword DRAFT = Keyword.of("$Draft");
    public static final Keyword SEEN = Keyword.of("$Seen");
    public static final Keyword FLAGGED = Keyword.of("$Flagged");
    public static final Keyword ANSWERED = Keyword.of("$Answered");
    public static final Keyword DELETED = Keyword.of("$Deleted");
    public static final Keyword RECENT = Keyword.of("$Recent");
    public static final Keyword FORWARDED = Keyword.of("$Forwarded");
    static final Boolean FLAG_VALUE = true;
    private static final ImmutableList<Keyword> NON_EXPOSED_IMAP_KEYWORDS = ImmutableList.of((Object)RECENT, (Object)DELETED);
    private static final ImmutableBiMap<Flags.Flag, Keyword> IMAP_SYSTEM_FLAGS = ImmutableBiMap.builder().put((Object)Flags.Flag.DRAFT, (Object)DRAFT).put((Object)Flags.Flag.SEEN, (Object)SEEN).put((Object)Flags.Flag.FLAGGED, (Object)FLAGGED).put((Object)Flags.Flag.ANSWERED, (Object)ANSWERED).put((Object)Flags.Flag.RECENT, (Object)RECENT).put((Object)Flags.Flag.DELETED, (Object)DELETED).build();
    public static final String VALIDATION_MESSAGE = "Flagname must not be null or empty, must have length form 1-255, must not contain charater with hex from '\\u0000' to '\\u00019' or {'(' ')' '{' ']' '%' '*' '\"' '\\'} ";
    private final String flagName;

    public static Optional<Keyword> parse(String flagName) {
        if (Keyword.isValid(flagName)) {
            return Optional.of(new Keyword(flagName));
        }
        return Optional.empty();
    }

    public static Keyword of(String flagName) {
        return Keyword.parse(flagName).orElseThrow(() -> new IllegalArgumentException(VALIDATION_MESSAGE));
    }

    public static Keyword fromFlag(Flags.Flag flag) {
        return (Keyword)IMAP_SYSTEM_FLAGS.get((Object)flag);
    }

    private static boolean isValid(String flagName) {
        if (StringUtils.isBlank((CharSequence)flagName)) {
            return false;
        }
        if (flagName.length() < 1 || flagName.length() > 255) {
            return false;
        }
        return FLAG_NAME_PATTERN.containsAll(flagName);
    }

    public Keyword(String flagName) {
        this.flagName = flagName;
    }

    public String getFlagName() {
        return this.flagName;
    }

    public boolean isExposedImapKeyword() {
        return !NON_EXPOSED_IMAP_KEYWORDS.contains((Object)this);
    }

    public boolean isDraft() {
        return DRAFT.equals(this);
    }

    public Optional<Flags.Flag> asSystemFlag() {
        return Optional.ofNullable((Flags.Flag)IMAP_SYSTEM_FLAGS.inverse().get((Object)this));
    }

    public Flags asFlags() {
        return this.asSystemFlag().map(Flags::new).orElse(new Flags(this.flagName));
    }

    public final boolean equals(Object other) {
        if (other instanceof Keyword) {
            Keyword otherKeyword = (Keyword)other;
            return Objects.equal((Object)this.flagName, (Object)otherKeyword.flagName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.flagName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flagName", (Object)this.flagName).toString();
    }
}

