/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.message.view.MessageView;
import org.apache.james.mailbox.model.MessageId;

@JsonDeserialize(builder=Builder.class)
public class GetMessagesResponse
implements Method.Response {
    private final List<MessageView> messages;
    private final List<MessageId> messagesNotFound;

    public static Builder builder() {
        return new Builder();
    }

    private GetMessagesResponse(List<MessageView> messages, List<MessageId> messagesNotFound) {
        this.messages = messages;
        this.messagesNotFound = messagesNotFound;
    }

    @JsonSerialize
    public List<MessageView> list() {
        return this.messages;
    }

    @JsonSerialize
    public List<MessageId> notFound() {
        return this.messagesNotFound;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private ImmutableList<MessageView> messages = ImmutableList.of();
        private List<MessageId> expectedMessageIds;

        private Builder() {
        }

        @JsonIgnore
        public Builder message(MessageView message) {
            this.messages = ImmutableList.of((Object)message);
            return this;
        }

        public Builder messages(List<? extends MessageView> messages) {
            this.messages = ImmutableList.copyOf(messages);
            return this;
        }

        public Builder expectedMessageIds(List<MessageId> expectedMessageIds) {
            this.expectedMessageIds = ImmutableList.copyOf(expectedMessageIds);
            return this;
        }

        public GetMessagesResponse build() {
            Preconditions.checkState((this.messages != null ? 1 : 0) != 0);
            return new GetMessagesResponse((List<MessageView>)this.messages, this.messagesNotFound());
        }

        private List<MessageId> messagesNotFound() {
            Set foundMessageIds = this.messages.stream().map(MessageView::getId).collect(Collectors.toSet());
            return ImmutableList.copyOf((Collection)this.expectedMessageIds.stream().filter(id -> !foundMessageIds.contains(id)).collect(Collectors.toList()));
        }
    }
}

